' "@(#)$Id: basadder,v 1.4 1999/03/19 00:14:20 donwm Exp $"
' Copyright (C) 1996 - 1999, Hewlett-Packard Company, all rights reserved.

' Visual Basic include file,
' for the VXI Plug&Play Instrument Driver for the HP E1432/33/34


'------------------------------------------------------------------------------
' Global Constants

'------------------------------------------------------------------------------


Global Const VI_WARN_NSUP_ID_QUERY		= &H30101
Global Const VI_WARN_NSUP_RESET			= &H30102
Global Const VI_WARN_NSUP_SELF_TEST		= &H30103
Global Const VI_WARN_NSUP_ERROR_QUERY		= &H30104
Global Const VI_WARN_NSUP_REV_QUERY		= &H30105

Global Const VI_ERROR_BASE			= &H80000000
Global Const VI_ERROR_PARAMETER1		= VI_ERROR_BASE+&HB0001
Global Const VI_ERROR_PARAMETER2		= VI_ERROR_BASE+&HB0002
Global Const VI_ERROR_PARAMETER3		= VI_ERROR_BASE+&HB0003
Global Const VI_ERROR_PARAMETER4		= VI_ERROR_BASE+&HB0004
Global Const VI_ERROR_PARAMETER5		= VI_ERROR_BASE+&HB0005
Global Const VI_ERROR_PARAMETER6		= VI_ERROR_BASE+&HB0006
Global Const VI_ERROR_PARAMETER7		= VI_ERROR_BASE+&HB0007
Global Const VI_ERROR_PARAMETER8		= VI_ERROR_BASE+&HB0008
Global Const VI_ERROR_FAIL_ID_QUERY		= VI_ERROR_BASE+&HB0011
Global Const VI_ERROR_INV_RESPONSE		= VI_ERROR_BASE+&HB0012
Global Const VI_ERROR_CALIBRATION_FAILURE	= VI_ERROR_BASE+&HB0013

Global Const HPE1432_IRQ_MEAS_WARNING		= &H0100
Global Const HPE1432_IRQ_BLOCK_READY		= &H0200
Global Const HPE1432_IRQ_MEAS_STATE_CHANGE	= &H0400
Global Const HPE1432_IRQ_TRIGGER		= &H0800
Global Const HPE1432_IRQ_OVERLOAD_CHANGE	= &H1000
Global Const HPE1432_IRQ_MEAS_ERROR		= &H2000
Global Const HPE1432_IRQ_TACHS_AVAIL		= &H4000
Global Const HPE1432_IRQ_SRC_STATUS		= &H8000

Global Const HPE1432_PEAK_MODE_ON		= 581
Global Const HPE1432_RMS_MODE_ON		= 591

Global Const HPE1432_STATUS2_TACH_OVERFLOW	= &H0001
Global Const HPE1432_STATUS2_FIFO_EMPTIED	= &H0002

Global Const HPE1432_MEAS_STATE_TESTED		= &H0000
Global Const HPE1432_MEAS_STATE_BOOTING		= &H0001
Global Const HPE1432_MEAS_STATE_BOOTING_WAIT1	= &H0002
Global Const HPE1432_MEAS_STATE_BOOTING_WAIT2	= &H0003
Global Const HPE1432_MEAS_STATE_BOOTED		= &H0004
Global Const HPE1432_MEAS_STATE_SYNC		= &H0005
Global Const HPE1432_MEAS_STATE_SYNC_WAIT1	= &H0006
Global Const HPE1432_MEAS_STATE_PRE_ARM		= &H0007
Global Const HPE1432_MEAS_STATE_PRE_ARM_WAIT2	= &H0008
Global Const HPE1432_MEAS_STATE_IDLE		= &H0009
Global Const HPE1432_MEAS_STATE_ARM		= &H000a
Global Const HPE1432_MEAS_STATE_ARM_WAIT1	= &H000b
Global Const HPE1432_MEAS_STATE_ARM_WAIT2	= &H000c
Global Const HPE1432_MEAS_STATE_TRIGGER		= &H000d
Global Const HPE1432_MEAS_STATE_CONVERT		= &H000e
Global Const HPE1432_MEAS_STATE_CONVERT_WAIT1	= &H000f
Global Const HPE1432_MEAS_STATE_CONVERT_WAIT2	= &H0010
Global Const HPE1432_MEAS_STATE_ERROR		= &H0012
Global Const HPE1432_MEAS_STATE_ERROR_WAIT1	= &H0013
Global Const HPE1432_MEAS_STATE_ERROR_WAIT2	= &H0014
Global Const HPE1432_MEAS_STATE_DUMMY2		= &H0015
Global Const HPE1432_MEAS_STATE_TPUT		= &H0016

Global Const HPE1432_SRCBUF_RDY			= &H00000000
Global Const HPE1432_SRCBUF_AVAIL		= &H00000001
Global Const HPE1432_SRCBUF_FULL		= &H00000002
Global Const HPE1432_SRCBUF_OUT			= &H00000004

Global Const HPE1432_TACH_RAW_SIZE		= 16384
Global Const HPE1432_TACH_WRAP_COUNT		= 4294967296.0

' duplicate of manual trigger
Global Const HPE1432_TACH_EDGE_TRIGGER		= 440

Global Const HPE1432_TRAILER_INFO_NOT_UNDERRANGE	= &H0001
Global Const HPE1432_TRAILER_INFO_OVERLOAD	= &H0002
Global Const HPE1432_TRAILER_INFO_OVERLOAD_COMM	= &H0004
Global Const HPE1432_TRAILER_INFO_TRIGGER	= &H0008
Global Const HPE1432_TRAILER_INFO_SETTLED	= &H0010
Global Const HPE1432_TRAILER_INFO_STOP		= &H0020
Global Const HPE1432_TRAILER_INFO_OT_RAMP_TOO_FAST	= &H0040
Global Const HPE1432_TRAILER_INFO_EXTEND	= &H0080
Global Const HPE1432_TRAILER_INFO_DEC_2_MASK	= &H1f00
Global Const HPE1432_TRAILER_INFO_DEC_2_SHIFT	= 8
Global Const HPE1432_TRAILER_INFO_DEC_5		= &H2000

Global Const HPE1432_TTLTRG_01			= 250
Global Const HPE1432_TTLTRG_23			= 251
Global Const HPE1432_TTLTRG_45			= 252
Global Const HPE1432_TTLTRG_67			= 253

' SCA IDs
Global Const HPE1432_SCA_ID_UNKNOWN		= -1   ' unknown if SCA present
Global Const HPE1432_SCA_ID_IGNORE		= 0    ' disregard this SCA
Global Const HPE1432_SCA_ID_NONE		= &H1f ' no SCA present
Global Const HPE1432_SCA_ID_INPUT		= &H18 ' undetermined input SCA
Global Const HPE1432_SCA_ID_SOURCE		= &H19 ' undetermined src SCA
Global Const HPE1432_SCA_ID_TACH		= 4
Global Const HPE1432_SCA_ID_CLARINET		= 6
Global Const HPE1432_SCA_ID_VIBRATO		= 10
Global Const HPE1432_SCA_ID_SONATA		= 12
Global Const HPE1432_SCA_ID_CLARION		= 7

Global Const HPE1432_DRAM_UNKNOWN		= -1
Global Const HPE1432_DRAM_IGNORE		= 0
Global Const HPE1432_DRAM_4M			= 4
Global Const HPE1432_DRAM_32M			= 32

' Smart break-out box IDs
Global Const HPE1432_BOB_ID_NONE		= 0
Global Const HPE1432_BOB_ID_CHARGE_PROTO	= 254
Global Const HPE1432_BOB_ID_MIKE_PROTO		= 253
Global Const HPE1432_BOB_ID_CHARGE		= 252
Global Const HPE1432_BOB_ID_MIKE		= 251
Global Const HPE1432_BOB_ID_CHARGE2		= 250
Global Const HPE1432_BOB_ID_MIKE2		= 249

' Channel software characteristics
Global Const HPE1432_CHAN_TYPE_INPUT		= 0
Global Const HPE1432_CHAN_TYPE_SOURCE		= 1
Global Const HPE1432_CHAN_TYPE_TACH		= 2
Global Const HPE1432_CHAN_TYPE_OTHER		= 3

Global Const HPE1432_OCTAVE_INT_TIME_STEP	= 2.0
Global Const HPE1432_WINDOW_SIZE_MAX		= 8192

' VXI Address offsets of registers from module base address
' VXI Configuration registers
Global Const HPE1432_ID_REG			= 0
Global Const HPE1432_LOGICAL_ADDRESS_REG	= 0
Global Const HPE1432_DEVICE_TYPE_REG		= 2
Global Const HPE1432_STATUS_REG			= 4
Global Const HPE1432_CONTROL_REG		= 4
Global Const HPE1432_OFFSET_REG			= 6
Global Const HPE1432_PORT_CTL_REG		= 8
Global Const HPE1432_PAGE_MAP_REG		= 10
Global Const HPE1432_IRQ_CONFIG_REG		= 12
Global Const HPE1432_IRQ_STATUS_REG		= 14
Global Const HPE1432_IRQ_STATUS2_REG		= 16
Global Const HPE1432_MEAS_STATE_REG		= 20
Global Const HPE1432_FIFO_DATA_REG		= 24
Global Const HPE1432_FIFO_COUNT_REG		= 30

Global Const HPE1432_NO_WARNING			= 0
Global Const HPE1432_LOST_NOT_ENOUGH_TACHS	= 1
Global Const HPE1432_LOST_TOO_MANY_TACHS	= 2
Global Const HPE1432_LOST_TOO_MANY_POINTS_REQUIRED	= 3
Global Const HPE1432_LOST_DATA_SHIFTED_OUT_FIFO	= 4
Global Const HPE1432_LOST_NOT_ENOUGH_DATA_FIFO	= 5
Global Const HPE1432_LOST_RPM_TOO_HIGH		= 6
Global Const HPE1432_LOST_RPM_TOO_LOW		= 7
Global Const HPE1432_LOST_RESAMPLE_ERROR	= 8
Global Const HPE1432_LOST_FIFO_EMPTIED		= 9
Global Const HPE1432_RPM_RAMP_TOO_FAST		= 10

' misc defines, may be superfluous
Global Const HPE1432_AC_RANGING_TIME		= 2.0
Global Const HPE1432_AC_SETTLING_TIME		= 15.0
Global Const HPE1432_ANALOG_DELAY		= 11.925E-6
Global Const HPE1432_CONTROL_A24_ENABLE		= &H8000
Global Const HPE1432_CONTROL_RESET_OFF		= &H0000
Global Const HPE1432_CONTROL_RESET_ON		= &H0001
Global Const HPE1432_CONTROL_SYSFAIL_INHIBIT_OFF = &H0000
Global Const HPE1432_CONTROL_SYSFAIL_INHIBIT_ON	= &H0002
Global Const HPE1432_DATA_MODE_OVERLAP_FREERUN	= 343
' HPE1432_DATA_SIZE_FRACT is for internal use only
Global Const HPE1432_DATA_SIZE_FRACT		= 758
Global Const HPE1432_DATA_SIZE_NONE		= 330
Global Const HPE1432_DATA_USER1			= 730
Global Const HPE1432_DATA_USER2			= 731
Global Const HPE1432_DECIMATION_MAX		= 16
Global Const HPE1432_DECIMATION_MIN		= 0
Global Const HPE1432_ENABLE_TYPE_USER1		= 274
Global Const HPE1432_ENABLE_TYPE_USER2		= 275
Global Const HPE1432_FFT_BLOCKSIZE_MAX		= 8192
Global Const HPE1432_FFT_BLOCKSIZE_MIN		= 64
Global Const HPE1432_GROUP_INFO_LIST_SOURCE	= 237
Global Const HPE1432_IRQ_ENABLE			= &H0008
Global Const HPE1432_IRQ_PRIORITY		= &H0007
Global Const HPE1432_IRQ_PRIORITY_MAX		= &H0007
Global Const HPE1432_IRQ_PRIORITY_MIN		= &H0001
Global Const HPE1432_IRQ_PRIORITY_NONE		= &H0000
Global Const HPE1432_IRQ_SHIFT			= 8
Global Const HPE1432_LBUS_DISABLE		= &H0000
Global Const HPE1432_LBUS_ENABLE		= &H0001
Global Const HPE1432_LBUS_PIPE			= &H0003
Global Const HPE1432_MAN_ID			= &Hfff
Global Const HPE1432_MEAS_STATE_DUMMY		= &H0011
Global Const HPE1432_MEAS_STATE_MASK		= &H001f
Global Const HPE1432_MEAS_STATE_MAX		= &H0017
Global Const HPE1432_MODEL_CODE			= &H201
Global Const HPE1432_MODEL_CODE_E1432		= &H201
Global Const HPE1432_MODEL_CODE_E1433		= &H202
Global Const HPE1432_MODEL_CODE_E1434		= &H203
Global Const HPE1432_MODEL_CODE_NOT_BOOTED	= &H200
Global Const HPE1432_MODULES			= 255
Global Const HPE1432_MOD_MAX			= 15
Global Const HPE1432_MULTIPASS			= 621
Global Const HPE1432_NUM_SPANS_MAX		= 6
Global Const HPE1432_ONEPASS			= 620
Global Const HPE1432_ORDER_BLOCKSIZE_MAX	= 8192
Global Const HPE1432_OVHD			= 2.189784
Global Const HPE1432_SCAS			= 5
Global Const HPE1432_SELFTEST_ALL_MODULES	= &H0001
Global Const HPE1432_SELFTEST_FAST		= &H0002
Global Const HPE1432_SELFTEST_LONG		= &H0004
Global Const HPE1432_SELFTEST_VXI		= &H0001 ' VXI interface
Global Const HPE1432_SELFTEST_ASRAM		= &H0002 ' substrate ASRAM
Global Const HPE1432_SELFTEST_BSRAM		= &H0004 ' substrate ASRAM
Global Const HPE1432_SELFTEST_DSP		= &H0008 ' 96002
Global Const HPE1432_SELFTEST_96K_HOSTPORT	= &H0010 ' 96002 hostport
Global Const HPE1432_SELFTEST_PLL		= &H0020 ' substrate PLL
Global Const HPE1432_SELFTEST_FLASH		= &H0040 ' substrate FLASH PROM
Global Const HPE1432_SELFTEST_MAIN		= &H00ff ' all of the above
Global Const HPE1432_SELFTEST_MAIN_IGNORE	= &H0000 ' none of the above
Global Const HPE1432_SELFTEST_NON_DL		= &H0001 ' non download testing
Global Const HPE1432_SELFTEST_DL		= &H0002 ' download testing
Global Const HPE1432_SELFTEST_STD_IO		= &H0004 ' std in, out testing
Global Const HPE1432_SELFTEST_BASIC		= &H0001 ' non download testing
Global Const HPE1432_SELFTEST_FULL		= &H0003 ' non and dld testing
Global Const HPE1432_SELFTEST_FULL_STD_IO	= &H0007 ' both plus stdin, out
Global Const HPE1432_SOURCE_COLA_DRPEPPER	= 182
Global Const HPE1432_SOURCE_MODE_ARB_ROFF	= 188
Global Const HPE1432_SOURCE_MODE_BARB_ROFF	= 189
Global Const HPE1432_SOURCE_MODE_BDNLD		= 179
Global Const HPE1432_SOURCE_MODE_BPRAND		= 185
Global Const HPE1432_SOURCE_MODE_BPRANDZ	= 187
Global Const HPE1432_SOURCE_MODE_BUSR		= 181
Global Const HPE1432_SOURCE_MODE_CLR		= 182
Global Const HPE1432_SOURCE_MODE_DNLD		= 178
Global Const HPE1432_SOURCE_MODE_MSINE		= 183
Global Const HPE1432_SOURCE_MODE_PRAND		= 184
Global Const HPE1432_SOURCE_MODE_PRANDZ		= 186
Global Const HPE1432_SOURCE_MODE_USR		= 180
Global Const HPE1432_SRCBUFFER_CONTINUOUS	= 1
Global Const HPE1432_SRCBUFFER_INIT_EMPTY	= 1
Global Const HPE1432_SRCBUFFER_INIT_RESET	= 2
Global Const HPE1432_SRCBUFFER_INIT_XFER	= 3
Global Const HPE1432_SRCBUFFER_PERIODIC_A	= 4
Global Const HPE1432_SRCBUFFER_PERIODIC_AB	= 2
Global Const HPE1432_SRCBUFFER_SWITCHEDAUTO	= 8
Global Const HPE1432_SRCBUFFER_SWITCHEDCMD	= 16
Global Const HPE1432_SRC_DATA_MODE_RAWCMD	= &H0000000A
Global Const HPE1432_SRC_DATA_MODE_RAWDATA	= &H00000009
Global Const HPE1432_SRC_DATA_MODE_RAWNACKCMD	= &H0000000E
Global Const HPE1432_SRC_DATA_MODE_RAWREAD	= &H0000000B
Global Const HPE1432_SRC_DATA_MODE_READID	= &H0000000D
Global Const HPE1432_SRC_DATA_MODE_READNCLRSTATUS	= &H0000000F
Global Const HPE1432_SRC_DATA_MODE_READSTATUS	= &H0000000C
Global Const HPE1432_SRC_STATUS_OVERLOAD0	= &H0800
Global Const HPE1432_SRC_STATUS_OVERLOAD2	= &H0400
Global Const HPE1432_SRC_STATUS_OVERLOAD4	= &H0200
Global Const HPE1432_SRC_STATUS_OVERREAD0	= &H0020
Global Const HPE1432_SRC_STATUS_OVERREAD2	= &H0010
Global Const HPE1432_SRC_STATUS_OVERREAD4	= &H0008
Global Const HPE1432_SRC_STATUS_REG		= &H8f0
Global Const HPE1432_SRC_STATUS_SHUTDOWN0	= &H0100
Global Const HPE1432_SRC_STATUS_SHUTDOWN2	= &H0080
Global Const HPE1432_SRC_STATUS_SHUTDOWN4	= &H0040
Global Const HPE1432_SRC_XFRBUF_WDS_EMPTY	= 0
Global Const HPE1432_STATUS_A24_ACTIVE		= &H8000
Global Const HPE1432_STATUS_BLOCK_READY		= &H0800
Global Const HPE1432_STATUS_CMD_READY		= &H0001
Global Const HPE1432_STATUS_DATA_READY		= &H0400
Global Const HPE1432_STATUS_DONE		= &H0080
Global Const HPE1432_STATUS_ERR_N		= &H0040
Global Const HPE1432_STATUS_HW_OK		= &H0010
Global Const HPE1432_STATUS_LOADED		= &H0100
Global Const HPE1432_STATUS_MODID_N		= &H4000
Global Const HPE1432_STATUS_PASSED		= &H0004
Global Const HPE1432_STATUS_Q_RESP_READY	= &H0002
Global Const HPE1432_STATUS_READY		= &H0008
Global Const HPE1432_STATUS_ST_DONE		= &H0200
Global Const HPE1432_STATUS_UNUSED1		= &H0020
Global Const HPE1432_STATUS_UNUSED2		= &H1000
Global Const HPE1432_STATUS_UNUSED3		= &H2000
Global Const HPE1432_TACH_CHANS			= 2
Global Const HPE1432_USER1_DATA			= 350
Global Const HPE1432_USER2_DATA			= 351
Global Const HPE1432_WINDOW_USER1		= 713
Global Const HPE1432_WINDOW_USER2		= 714
Global Const HPE1432_ZAP_BOOT			= 1
Global Const HPE1432_ZAP_CLAR_BOOT		= 6
Global Const HPE1432_ZAP_CLAR_ID_CAL		= 3
Global Const HPE1432_ZAP_ID_CAL			= 2
Global Const HPE1432_ZAP_SRC12_BOOT		= 7
Global Const HPE1432_ZAP_SRC12_ID_CAL		= 4
Global Const HPE1432_ZAP_SRC34_BOOT		= 8
Global Const HPE1432_ZAP_SRC34_ID_CAL		= 5


Global Const ERR1432_DIAG_ERR_UNDIAGNOSED	= -1592
Global Const ERR1432_DIAG_ERR_SUBST		= -1593
Global Const ERR1432_DIAG_ERR_DRAM		= -1594
Global Const ERR1432_DIAG_ERR_TACH		= -1595
Global Const ERR1432_DIAG_ERR_SOURCE_FIT	= -1596
Global Const ERR1432_DIAG_ERR_SOURCE_SCA0	= -1597
Global Const ERR1432_DIAG_ERR_SOURCE_SCA1	= -1598
Global Const ERR1432_DIAG_ERR_INPUT_SCA0	= -1599
Global Const ERR1432_DIAG_ERR_INPUT_SCA1	= -1600
Global Const ERR1432_DIAG_ERR_INPUT_SCA2	= -1601
Global Const ERR1432_DIAG_ERR_INPUT_SCA3	= -1602


Global Const HPE1432_OCTAVE_AVG_MODE_DEF	= 760
Global Const HPE1432_OCTAVE_HOLD_MODE_DEF	= 765
Global Const HPE1432_OCTAVE_INT_TIME_DEF	= 1.0
Global Const HPE1432_OCTAVE_MODE_DEF		= 752
Global Const HPE1432_OCTAVE_START_FREQ_DEF	= 3.15
Global Const HPE1432_OCTAVE_STOP_FREQ_DEF	= 20000.0
Global Const HPE1432_OCTAVE_TIME_CONST_DEF	= 0.125
Global Const HPE1432_OCTAVE_TIME_STEP_DEF	= 0.125

Global Const WARN1432_NO_WARNING		= 0
Global Const WARN1432_LOST_NOT_ENOUGH_TACHS	= 1
Global Const WARN1432_LOST_TOO_MANY_TACHS	= 2
Global Const WARN1432_LOST_TOO_MANY_POINTS_REQUIRED	= 3
Global Const WARN1432_LOST_DATA_SHIFTED_OUT_FIFO	= 4
Global Const WARN1432_LOST_NOT_ENOUGH_DATA_FIFO	= 5
Global Const WARN1432_LOST_RPM_TOO_HIGH		= 6
Global Const WARN1432_LOST_RPM_TOO_LOW		= 7
Global Const WARN1432_LOST_RESAMPLE_ERROR	= 8
Global Const WARN1432_LOST_FIFO_EMPTIED		= 9
Global Const WARN1432_RPM_RAMP_TOO_FAST		= 10

' Used by Function hpe1432_setSrcOffMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SRCOFF_MODE_RAMP			  = 0
Global Const HPE1432_SRCOFF_MODE_IMMED			  = 1

'structure returned by hpe1432_getHWConfig()
Type hpe1432_hwconfig
    man_id As Long          'VXI manufacturer ID number & 0x1000 if octave
    model_code As Long      'VXI Model code
    hw_rev As Long          'hardware revision. 1 + clock/trig xilinx
    bootrom_rev As Long     'Flash boot prog rev.  YYYYMMDD
    fw_rev As Long          'firmware revision.  YYYYMMDD
    sca_id(1 To HPE1432_SCAS) As Long
    sca_rev(1 To HPE1432_SCAS) As Long    '0 to n
    bob_id(1 To HPE1432_SCAS) As Long      'Break-out Box type
    total_chans As Long
    input_chans As Long
    source_chans As Long
    tach_chans As Long
    lbus_present As Long
    dram_size As Long      'number of 32-bit words
    a24_used As Long       'bytes of VXI A24 memory used
End Type

Declare Function hpe1432_setInternalDebug Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal intDebug As Long) As Long

Declare Function hpe1432_getInternalDebug Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, intDebug As Long) As Long

Declare Function hpe1432_getInternalDebugLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_initA Lib "hpe1432_32.dll" (ByVal rsrcName As String, ByVal id_query As Integer, ByVal reset As Integer, vi As Long) As Long

Declare Function hpe1432_initB Lib "hpe1432_32.dll" (ByVal rsrcName As String, ByVal id_query As Integer, ByVal reset As Integer, vi As Long) As Long

Declare Function hpe1432_initB2 Lib "hpe1432_32.dll" (ByVal rsrcName As String, ByVal id_query As Integer, ByVal reset As Integer, vi As Long) As Long

Declare Function hpe1432_initB3 Lib "hpe1432_32.dll" (ByVal rsrcName As String, ByVal id_query As Integer, ByVal reset As Integer, vi As Long) As Long

Declare Function hpe1432_initC Lib "hpe1432_32.dll" (ByVal rsrcName As String, ByVal id_query As Integer, ByVal reset As Integer, vi As Long) As Long

Declare Function hpe1432_displayState Lib "hpe1432_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1432_getSrcOffMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, srcOffMode As Long) As Long

Declare Function hpe1432_setSrcOffMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal srcOffMode As Long) As Long

Declare Function hpe1432_getCurrentValue32 Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal channel As Long, ByVal valueType As Long, curVal As Single) As Long

Declare Function hpe1432_readFloat32Data Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal which As Long, data As Single, ByVal size As Long, actualCnt As Long, ByVal wait As Long) As Long

Declare Function hpe1432_getLockMode Lib "hpe1432_32.dll" (ByVal vi As Long, mode As Long) As Long

Declare Function hpe1432_setLockMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal mode As Long) As Long

Declare Function hpe1432_getUserDecimation Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal channel As Long, viparm As Long) As Long

Declare Function hpe1432_setUserDecimation Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal channel As Long, ByVal dec As Long) As Long

Declare Function hpe1432_getUserFramesPerBlock Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal channel As Long, viparm As Long) As Long

Declare Function hpe1432_setUserFramesPerBlock Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal channel As Long, ByVal fpb As Long) As Long

' phpe1432.bas follows



'------------------------------------------------------------------------------
' Global Constants

'------------------------------------------------------------------------------

' Used by Function hpe1432_armMeasure
Global Const HPE1432_GROUP_ID_MAX                         = 12288
Global Const HPE1432_GROUP_ID_MIN                         = -8000
Global Const HPE1432_NO_WAIT_FLAG                         = 0
Global Const HPE1432_WAIT_FLAG                            = 1

' Used by Function hpe1432_armMeasureMasterFinish
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_armMeasureMasterSetup
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_armMeasureSlaveFinish
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_arrayControl
Global Const HPE1432_ARRAYCONTROL_MAX_CHANS               = 200
Global Const HPE1432_ARRAYCONTROL_MIN_CHANS               = 1

' Used by Function hpe1432_autoRange
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_AUTO_RANGE_TIME_MAX                  = 86400.0
Global Const HPE1432_AUTO_RANGE_TIME_MIN                  = 0.0

' Used by Function hpe1432_autoZero
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_blockAvailable
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_cachedParmUpdate
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

Global Const HPE1432_CHANNEL_ID_MAX                       = 12287
Global Const HPE1432_CHANNEL_ID_MIN                       = 1
Global Const HPE1432_CB_MASK_MAX                          = 16383
Global Const HPE1432_CB_MASK_MIN                          = 0

' Used by Function hpe1432_channelGroupAdd
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_CHANNEL_ID_MAX
'    HPE1432_CHANNEL_ID_MIN

' Used by Function hpe1432_channelGroupRemove
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_CHANNEL_ID_MAX
'    HPE1432_CHANNEL_ID_MIN

' Used by Function hpe1432_checkOverloads
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_checkSrcArbRdy
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SRC_DATA_MODE_WAITA                  = 4
Global Const HPE1432_SRC_DATA_MODE_WAITB                  = 5
Global Const HPE1432_SRC_DATA_MODE_WAITAB                 = 6

' Used by Function hpe1432_checkSrcOverload
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_checkSrcOverread
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_checkSrcShutdown
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_checkSrcUnderrun
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_createChannelGroup
Global Const HPE1432_NUM_CHANNELS_MAX                     = 4080
Global Const HPE1432_NUM_CHANNELS_MIN                     = 0

' Used by Function hpe1432_deleteChannelGroup
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_errorDetails
Global Const HPE1432_ERROR_DETAIL_LEN_MAX                 = 128
Global Const HPE1432_ERROR_DETAIL_LEN_MIN                 = 0

' Used by Function hpe1432_errorDetails2
'    HPE1432_ERROR_DETAIL_LEN_MAX
'    HPE1432_ERROR_DETAIL_LEN_MIN

' Used by Function hpe1432_error_message
Global Const HPE1432_VISTATUS_MAX                         = 2147483647
Global Const HPE1432_VISTATUS_MIN                         = 0

' Used by Function hpe1432_find
Global Const HPE1432_FIND_LIST_SIZE_MAX                   = 255
Global Const HPE1432_FIND_LIST_SIZE_MIN                   = 0
Global Const HPE1432_FIND_RSRC_LEN_MAX                    = 255
Global Const HPE1432_FIND_RSRC_LEN_MIN                    = 0

' Used by Function hpe1432_finishMeasure
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getActive
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getAmpScale
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getAmpScaleLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getAntiAliasAnalog
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getAntiAliasDigital
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getAppendStatus
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getArmChannel
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getArmMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getArmTimeInterval
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getArmTimeIntervalLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getAutoGroupMeas
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getAutoRangeMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getAutoTrigger
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getAvgMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getAvgNumber
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getAvgNumberLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getAvgUpdate
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getAvgUpdateLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getAvgWeight
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getAvgWeightLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getBlocksize
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getBlocksizeCurrentMax
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getBlocksizeLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getCalDac
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getCalDacLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getCalVoltage
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getCalVoltageLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getCalcData
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getCalin
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getCenterFreq
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getCenterFreqLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getClockFreq
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getClockFreqLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getClockMaster
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getClockSource
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getCoupling
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getCouplingFreq
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getCouplingFreqLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getCurrentData
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_OCTAVE_DATA                          = 350
Global Const HPE1432_DATA_SIZE_FLOAT32                    = 334
Global Const HPE1432_DATA_SIZE_FLOAT64                    = 759

' Used by Function hpe1432_getCurrentRpm
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getCurrentValue
'    HPE1432_CHANNEL_ID_MAX
'    HPE1432_CHANNEL_ID_MIN
Global Const HPE1432_CURRENT_VAL_PEAK                     = 589
Global Const HPE1432_CURRENT_VAL_RMS                      = 599
Global Const HPE1432_CURRENT_VAL_FIFO_AVAIL               = 600

'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_CURRENT_VAL_PEAK
'    HPE1432_CURRENT_VAL_RMS
'    HPE1432_CURRENT_VAL_FIFO_AVAIL

' Used by Function hpe1432_getDataMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getDataPort
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getDataRpm
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getDataSize
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getDecimation
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getDecimationOutput
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getDecimationOversample
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getDecimationUndersamp
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getDecimationUndersampLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getDeltaOrder
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getDeltaOrderLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getDutyCycle
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getDutyCycleLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getEnable
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_ENABLE_TYPE_TIME                     = 270
Global Const HPE1432_ENABLE_TYPE_FREQ                     = 271
Global Const HPE1432_ENABLE_TYPE_RESAMPLE                 = 272
Global Const HPE1432_ENABLE_TYPE_ORDER                    = 273

' Used by Function hpe1432_getFifoSize
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getFifoSizeCurrentMax
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getFifoSizeLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getFilterFreq
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getFilterFreqLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getFilterSettlingTime
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getFilterSettlingTimeLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getGroupInfo
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_GROUP_INFO_NUM_MODULES               = 230
Global Const HPE1432_GROUP_INFO_LIST_MODULES              = 231
Global Const HPE1432_GROUP_INFO_NUM_CHANNELS              = 232
Global Const HPE1432_GROUP_INFO_LIST_CHANNELS             = 233
Global Const HPE1432_GROUP_INFO_NUM_INPUTS                = 234
Global Const HPE1432_GROUP_INFO_LIST_INPUTS               = 235
Global Const HPE1432_GROUP_INFO_NUM_SOURCES               = 236
Global Const HPE1432_GROUP_INFO_LIST_SOURCES              = 237
Global Const HPE1432_GROUP_INFO_NUM_TACHS                 = 238
Global Const HPE1432_GROUP_INFO_LIST_TACHS                = 239
Global Const HPE1432_GROUP_INFO_SIZE_MAX                  = 500
Global Const HPE1432_GROUP_INFO_SIZE_MIN                  = 1

' Used by Function hpe1432_getHWConfig
Global Const HPE1432_GET_CONFIG_MAX                       = 255
Global Const HPE1432_GET_CONFIG_MIN                       = 1

' Used by Function hpe1432_getInputHigh
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getInputLow
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getInputMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getInputOffset
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getInputOffsetLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getInterruptMask
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getInterruptPriority
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getInterruptPriorityLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getInterruptReason
'    HPE1432_CHANNEL_ID_MAX
'    HPE1432_CHANNEL_ID_MIN

' Used by Function hpe1432_getLbusMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getLbusReset
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getMaxOrder
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getMaxOrderLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getMeasState
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getMeasTimeLength
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getMeasTimeLengthLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getMeasWarning
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_MEAS_WARN_BUFFER_MAX                 = 1024
Global Const HPE1432_MEAS_WARN_BUFFER_MIN                 = 0

' Used by Function hpe1432_getMeasWarningString
'    HPE1432_MEAS_WARN_BUFFER_MAX
'    HPE1432_MEAS_WARN_BUFFER_MIN
Global Const HPE1432_MEAS_WARNING_MAX                     = 9
Global Const HPE1432_MEAS_WARNING_MIN                     = 0

' Used by Function hpe1432_getMmfDelay
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getMultiSync
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getNextArmRpm
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getOctaveAvgMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getOctaveBlocksize
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getOctaveHoldMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getOctaveIntTime
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getOctaveIntTimeLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getOctaveMeas
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getOctaveMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getOctaveStartFreq
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getOctaveStartFreqLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getOctaveStopFreq
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getOctaveStopFreqLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getOctaveTimeConst
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getOctaveTimeConstLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getOctaveTimeStep
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getOctaveTimeStepLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getOverlap
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getOverlapLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getPeakDecayTime
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getPeakDecayTimeLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getPeakMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getPreArmMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getPreArmRpm
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getPreArmRpmLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRamp
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRampRate
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRampRateLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRange
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRangeCharge
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRangeChargeLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRangeLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRangeMike
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRangeMikeLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRawTachs
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_RAW_TACH_BUF_SIZE_MAX                = 8192
Global Const HPE1432_RAW_TACH_BUF_SIZE_MIN                = 0

' Used by Function hpe1432_getRmsAvgTime
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRmsAvgTimeLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRmsDecayTime
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRmsDecayTimeLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRmsMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRpmHigh
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRpmHighLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRpmInterval
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRpmIntervalLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRpmLow
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRpmLowLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRpmSmoothing
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getRpmSmoothingLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSampleMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSamplesToPreArm
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getScale
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSerialNum
Global Const HPE1432_LA_MAX                               = 255
Global Const HPE1432_LA_MIN                               = 0

' Used by Function hpe1432_getSineFreq
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSineFreqLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSinePhase
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSinePhaseLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSourceBlocksize
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSourceBlocksizeLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSourceCenterFreq
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSourceCenterFreqLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSourceCola
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSourceMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSourceOutput
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSourceSeed
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSourceSeedLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSourceSpan
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSourceSpanLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSourceSum
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSpan
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSpanLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSrcArbStates
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSrcBufferInit
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSrcBufferMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSrcBufferSize
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSrcBufferSizeLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSrcParmMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getSumbus
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTachClockFreq
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTachDecimate
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTachDecimateLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTachDelay
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTachHoldoff
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTachHoldoffLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTachIrqNumber
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTachIrqNumberLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTachMaxTime
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTachMaxTimeLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTachPpr
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTachPprLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTrigCorr
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTriggerChannel
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTriggerDelay
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTriggerDelayLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTriggerExt
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTriggerLevel
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_TRIGGER_LEVEL_LOWER                  = 416
Global Const HPE1432_TRIGGER_LEVEL_UPPER                  = 417

' Used by Function hpe1432_getTriggerLevelLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_TRIGGER_LEVEL_LOWER
'    HPE1432_TRIGGER_LEVEL_UPPER

' Used by Function hpe1432_getTriggerMaster
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTriggerMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTriggerSlope
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTriggersPerArm
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTriggersPerArmLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTtltrgClock
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTtltrgGclock
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTtltrgLines
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTtltrgSatrg
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getTtltrgTrigger
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getWeighting
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getWindow
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getXferSize
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getXferSizeLimits
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_getZoom
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_initMeasure
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_initMeasureFinish
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_NO_WAIT_FLAG
'    HPE1432_WAIT_FLAG

' Used by Function hpe1432_initMeasureToBooted
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_NO_WAIT_FLAG
'    HPE1432_WAIT_FLAG

' Used by Function hpe1432_install
Global Const HPE1432_INSTALL_MAX                          = 15
Global Const HPE1432_INSTALL_MIN                          = 1

' Used by Function hpe1432_installFile
Global Const HPE1432_INSTALL_FILE                         = 0
Global Const HPE1432_INSTALL_MEM                          = 1

' Used by Function hpe1432_octaveCtl
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_OCTAVE_CTL_STOP                      = 770
Global Const HPE1432_OCTAVE_CTL_RESTART                   = 771
Global Const HPE1432_OCTAVE_CTL_CONTINUE                  = 772

' Used by Function hpe1432_preArmMeasure
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_NO_WAIT_FLAG
'    HPE1432_WAIT_FLAG

' Used by Function hpe1432_preset
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_TIME_DATA                            = 345
Global Const HPE1432_FREQ_DATA                            = 346
Global Const HPE1432_RESAMP_DATA                          = 347
Global Const HPE1432_ORDER_DATA                           = 348
Global Const HPE1432_REQUEST_DATA                         = 349
'    HPE1432_OCTAVE_DATA
Global Const HPE1432_BLOCKSIZE_MAX                        = 16777215
Global Const HPE1432_BLOCKSIZE_MIN                        = 1
'    HPE1432_NO_WAIT_FLAG
'    HPE1432_WAIT_FLAG

' Used by Function hpe1432_readFloat64Data
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_TIME_DATA
'    HPE1432_FREQ_DATA
'    HPE1432_RESAMP_DATA
'    HPE1432_ORDER_DATA
'    HPE1432_REQUEST_DATA
'    HPE1432_OCTAVE_DATA
'    HPE1432_BLOCKSIZE_MAX
'    HPE1432_BLOCKSIZE_MIN
'    HPE1432_NO_WAIT_FLAG
'    HPE1432_WAIT_FLAG

' Used by Function hpe1432_readI2C
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_I2C_ADDRESS_MAX                      = 255
Global Const HPE1432_I2C_ADDRESS_MIN                      = 0

' Used by Function hpe1432_readRawData
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_TIME_DATA
'    HPE1432_FREQ_DATA
'    HPE1432_RESAMP_DATA
'    HPE1432_ORDER_DATA
'    HPE1432_REQUEST_DATA
'    HPE1432_OCTAVE_DATA
'    HPE1432_BLOCKSIZE_MAX
'    HPE1432_BLOCKSIZE_MIN
'    HPE1432_NO_WAIT_FLAG
'    HPE1432_WAIT_FLAG

' Used by Function hpe1432_readRegister16
'    HPE1432_CHANNEL_ID_MAX
'    HPE1432_CHANNEL_ID_MIN
Global Const HPE1432_REGISTER_MIN                         = 0
Global Const HPE1432_REGISTER_MAX                         = 64

' Used by Function hpe1432_readRegister32
'    HPE1432_CHANNEL_ID_MAX
'    HPE1432_CHANNEL_ID_MIN
'    HPE1432_REGISTER_MIN
'    HPE1432_REGISTER_MAX

' Used by Function hpe1432_reenableInterrupt
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_resetLbus
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_RESET_LBUS_ON                        = 306
Global Const HPE1432_RESET_LBUS_OFF                       = 307

' Used by Function hpe1432_resetMeasure
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_scaDspDownload
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SCADOWNLOAD_MAX                      = 4096
Global Const HPE1432_SCADOWNLOAD_MIN                      = 0

' Used by Function hpe1432_scaDspExecQuery
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_EXEC_CMD_MAX                         = 255
Global Const HPE1432_EXEC_CMD_MIN                         = 0
Global Const HPE1432_EXEC_DATA_SIZE_MAX                   = 224
Global Const HPE1432_EXEC_DATA_SIZE_MIN                   = 0
Global Const HPE1432_QUERY_DATA_SIZE_MAX                  = 224
Global Const HPE1432_QUERY_DATA_SIZE_MIN                  = 0

' Used by Function hpe1432_sendTachs
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_RAW_TACH_BUF_SIZE_MAX
'    HPE1432_RAW_TACH_BUF_SIZE_MIN

' Used by Function hpe1432_sendTrigger
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_setActive
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_CHANNEL_ON                           = 420
Global Const HPE1432_CHANNEL_OFF                          = 421
Global Const HPE1432_CHANNEL_MAYBE                        = 422

' Used by Function hpe1432_setAmpScale
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_AMP_SCALE_MAX                        = 1.0
Global Const HPE1432_AMP_SCALE_MIN                        = 0.0

' Used by Function hpe1432_setAnalogInput
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_INPUT_MODE_VOLT                      = 130
Global Const HPE1432_INPUT_MODE_ICP                       = 131
Global Const HPE1432_INPUT_MODE_CHARGE                    = 132
Global Const HPE1432_INPUT_MODE_MIC                       = 133
Global Const HPE1432_INPUT_HIGH_NORMAL                    = 120
Global Const HPE1432_INPUT_HIGH_CALIN                     = 121
Global Const HPE1432_INPUT_HIGH_GROUNDED                  = 122
Global Const HPE1432_INPUT_HIGH_CALOUT                    = 123
Global Const HPE1432_ANTI_ALIAS_ANALOG_ON                 = 112
Global Const HPE1432_ANTI_ALIAS_ANALOG_OFF                = 113
Global Const HPE1432_COUPLING_AC                          = 100
Global Const HPE1432_COUPLING_DC                          = 101
Global Const HPE1432_COUPLING_AC_BOB_HP                   = 102
Global Const HPE1432_COUPLING_DC_BOB_HP                   = 103
Global Const HPE1432_RANGE_MAX                            = 20.0
Global Const HPE1432_RANGE_MIN                            = 0.0

' Used by Function hpe1432_setAntiAliasAnalog
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_ANTI_ALIAS_ANALOG_ON
'    HPE1432_ANTI_ALIAS_ANALOG_OFF

' Used by Function hpe1432_setAntiAliasDigital
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_ANTI_ALIAS_DIGITAL_ON                = 615
Global Const HPE1432_ANTI_ALIAS_DIGITAL_OFF               = 616
Global Const HPE1432_ANTI_ALIAS_DIGITAL_BES               = 617

' Used by Function hpe1432_setAppendStatus
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_APPEND_STATUS_OFF                    = 310
Global Const HPE1432_APPEND_STATUS_ON                     = 311

' Used by Function hpe1432_setArmChannel
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_CHANNEL_ON
'    HPE1432_CHANNEL_OFF

' Used by Function hpe1432_setArmMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_AUTO_ARM_CONTINUOUS                  = 429
Global Const HPE1432_MANUAL_ARM                           = 430
Global Const HPE1432_AUTO_ARM                             = 431
Global Const HPE1432_ARM_RPM_RUNUP                        = 432
Global Const HPE1432_ARM_RPM_RUNDOWN                      = 433
Global Const HPE1432_ARM_RPM_DELTA                        = 434
Global Const HPE1432_ARM_TIME                             = 436
Global Const HPE1432_ARM_TIME_OR_RPM                      = 437

' Used by Function hpe1432_setArmTimeInterval
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_ARM_TIME_INTERVAL_MAX                = 2000000000.0
Global Const HPE1432_ARM_TIME_INTERVAL_MIN                = 0.0001

' Used by Function hpe1432_setAutoGroupMeas
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_AUTO_GROUP_MEAS_ON                   = 242
Global Const HPE1432_AUTO_GROUP_MEAS_OFF                  = 243

' Used by Function hpe1432_setAutoRangeMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_AUTO_RANGE_MODE_UP                   = 1
Global Const HPE1432_AUTO_RANGE_MODE_DOWN                 = 2
Global Const HPE1432_AUTO_RANGE_MODE_DEF                  = 3

' Used by Function hpe1432_setAutoTrigger
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_MANUAL_TRIGGER                       = 440
Global Const HPE1432_AUTO_TRIGGER                         = 441

' Used by Function hpe1432_setAvgMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_AVG_NONE                             = 700
Global Const HPE1432_AVG_RMS                              = 701
Global Const HPE1432_AVG_LIN                              = 702
Global Const HPE1432_AVG_EXPO                             = 703
Global Const HPE1432_AVG_PEAK                             = 704

' Used by Function hpe1432_setAvgNumber
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_AVG_NUMBER_MAX                       = 2147483647
Global Const HPE1432_AVG_NUMBER_MIN                       = 0

' Used by Function hpe1432_setAvgUpdate
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_AVG_UPDATE_MAX                       = 2147483646
Global Const HPE1432_AVG_UPDATE_MIN                       = 1.0

' Used by Function hpe1432_setAvgWeight
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_AVG_WEIGHT_MAX                       = 1.0e20
Global Const HPE1432_AVG_WEIGHT_MIN                       = 1.0

' Used by Function hpe1432_setBlocksize
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_BLOCKSIZE_MAX
'    HPE1432_BLOCKSIZE_MIN

' Used by Function hpe1432_setCalDac
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_CAL_DAC_MAX                          = 2048
Global Const HPE1432_CAL_DAC_MIN                          = -2048

' Used by Function hpe1432_setCalVoltage
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_CAL_VOLTAGE_MAX                      = 15
Global Const HPE1432_CAL_VOLTAGE_MIN                      = -15

' Used by Function hpe1432_setCalcData
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_DATA_TIME                            = 724
Global Const HPE1432_DATA_FREQ                            = 725
Global Const HPE1432_DATA_RESAMP_TIME                     = 726
Global Const HPE1432_DATA_ORDER                           = 727
Global Const HPE1432_DATA_CORR_FREQ                       = 728
Global Const HPE1432_DATA_FIR                             = 729
Global Const HPE1432_DATA_OCTAVE                          = 730

' Used by Function hpe1432_setCalin
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_CALIN_OPEN                           = 510
Global Const HPE1432_CALIN_GROUND                         = 511
Global Const HPE1432_CALIN_DC_HI                          = 512
Global Const HPE1432_CALIN_DC_LO                          = 513
Global Const HPE1432_CALIN_SUMBUS                         = 514
Global Const HPE1432_CALIN_CALOUT                         = 515
Global Const HPE1432_CALIN_SUMBUS_TACH                    = 516

' Used by Function hpe1432_setCenterFreq
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_CENTER_FREQ_MAX                      = 128000.0
Global Const HPE1432_CENTER_FREQ_MIN                      = 0.0

' Used by Function hpe1432_setClockFreq
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_CLOCK_FREQ_MAX                       = 200000.0
Global Const HPE1432_CLOCK_FREQ_MIN                       = 40960.0

' Used by Function hpe1432_setClockMaster
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_MASTER_CLOCK_ON                      = 240
Global Const HPE1432_MASTER_CLOCK_OFF                     = 241

' Used by Function hpe1432_setClockSource
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_CLOCK_VXI_DEC_3                      = 204
Global Const HPE1432_CLOCK_SOURCE_EXTERNAL                = 206
Global Const HPE1432_CLOCK_SOURCE_EXTERNALN               = 207
Global Const HPE1432_CLOCK_SOURCE_INTERNAL                = 208
Global Const HPE1432_CLOCK_SOURCE_VXI                     = 209
Global Const HPE1432_CLOCK_SOURCE_VXI10                   = 210

' Used by Function hpe1432_setCoupling
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_COUPLING_AC
'    HPE1432_COUPLING_DC
'    HPE1432_COUPLING_AC_BOB_HP
'    HPE1432_COUPLING_DC_BOB_HP

' Used by Function hpe1432_setCouplingFreq
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_COUPLING_FREQ_MAX                    = 100.0
Global Const HPE1432_COUPLING_FREQ_MIN                    = 0.0

' Used by Function hpe1432_setDataFormat
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_BLOCKSIZE_MAX
'    HPE1432_BLOCKSIZE_MIN
Global Const HPE1432_DATA_SIZE_16                         = 331
Global Const HPE1432_DATA_SIZE_32                         = 332
Global Const HPE1432_DATA_SIZE_32_SERV                    = 333
'    HPE1432_DATA_SIZE_FLOAT32
Global Const HPE1432_BLOCK_MODE                           = 340
Global Const HPE1432_CONTINUOUS_MODE                      = 341
Global Const HPE1432_DATA_MODE_OVERLAP_BLOCK              = 342
Global Const HPE1432_DATA_MODE_OVERLAP_FREE               = 343
'    HPE1432_APPEND_STATUS_OFF
'    HPE1432_APPEND_STATUS_ON

' Used by Function hpe1432_setDataMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_BLOCK_MODE
'    HPE1432_CONTINUOUS_MODE
'    HPE1432_DATA_MODE_OVERLAP_BLOCK
'    HPE1432_DATA_MODE_OVERLAP_FREE

' Used by Function hpe1432_setDataPort
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SEND_PORT_VME                        = 300
Global Const HPE1432_SEND_PORT_LBUS                       = 301
Global Const HPE1432_SEND_PORT_LBUS_EAVES                 = 302

' Used by Function hpe1432_setDataSize
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_DATA_SIZE_16
'    HPE1432_DATA_SIZE_32
'    HPE1432_DATA_SIZE_32_SERV
'    HPE1432_DATA_SIZE_FLOAT32

' Used by Function hpe1432_setDecimationOutput
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_ONE_PASS                             = 620
Global Const HPE1432_MULTI_PASS                           = 621

' Used by Function hpe1432_setDecimationOversample
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_DECIMATION_OVERSAMPLE_OFF            = 630
Global Const HPE1432_DECIMATION_OVERSAMPLE_ON             = 631

' Used by Function hpe1432_setDecimationUndersamp
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_DEC_UNDERSAMP_MAX                    = 16
Global Const HPE1432_DEC_UNDERSAMP_MIN                    = 1

' Used by Function hpe1432_setDeltaOrder
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_DELTA_ORDER_MAX                      = 1.0
Global Const HPE1432_DELTA_ORDER_MIN                      = 0.005

' Used by Function hpe1432_setDutyCycle
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_DUTY_CYCLE_MAX                       = 1.0
Global Const HPE1432_DUTY_CYCLE_MIN                       = 0.0

' Used by Function hpe1432_setEnable
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_ENABLE_TYPE_TIME
'    HPE1432_ENABLE_TYPE_FREQ
'    HPE1432_ENABLE_TYPE_RESAMPLE
'    HPE1432_ENABLE_TYPE_ORDER
Global Const HPE1432_ENABLE_TYPE_OCTAVE                   = 274
Global Const HPE1432_ENABLE_ON                            = 280
Global Const HPE1432_ENABLE_OFF                           = 281

' Used by Function hpe1432_setFifoSize
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_FIFO_SIZE_MAX                        = 16777215
Global Const HPE1432_FIFO_SIZE_MIN                        = 0

' Used by Function hpe1432_setFilterFreq
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_FILTER_FREQ_MAX                      = 25600
Global Const HPE1432_FILTER_FREQ_MIN                      = 2000

' Used by Function hpe1432_setFilterSettlingTime
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_FILTER_SETTLING_MAX                  = 10000.0
Global Const HPE1432_FILTER_SETTLING_MIN                  = 0.0

' Used by Function hpe1432_setInputHigh
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_INPUT_HIGH_NORMAL
'    HPE1432_INPUT_HIGH_CALIN
'    HPE1432_INPUT_HIGH_GROUNDED
'    HPE1432_INPUT_HIGH_CALOUT
Global Const HPE1432_INPUT_HIGH_BOB_CALIN                 = 124

' Used by Function hpe1432_setInputLow
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_INPUT_LOW_GROUNDED                   = 140
Global Const HPE1432_INPUT_LOW_FLOATING                   = 141

' Used by Function hpe1432_setInputMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_INPUT_MODE_VOLT
'    HPE1432_INPUT_MODE_ICP
'    HPE1432_INPUT_MODE_CHARGE
'    HPE1432_INPUT_MODE_MIC
Global Const HPE1432_INPUT_MODE_MIC_200V                  = 134

' Used by Function hpe1432_setInputOffset
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_INPUT_OFFSET_MAX                     = 20.0
Global Const HPE1432_INPUT_OFFSET_MIN                     = 0.0

' Used by Function hpe1432_setInterrupt
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_INT_PRIORITY_LEVEL_MAX               = 7
Global Const HPE1432_INT_PRIORITY_LEVEL_MIN               = 0
Global Const HPE1432_INT_MASK_MAX                         = 65535
Global Const HPE1432_INT_MASK_MIN                         = 0

' Used by Function hpe1432_setInterruptMask
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_INT_MASK_MAX
'    HPE1432_INT_MASK_MIN

' Used by Function hpe1432_setInterruptPriority
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_INT_PRIORITY_LEVEL_MAX
'    HPE1432_INT_PRIORITY_LEVEL_MIN

' Used by Function hpe1432_setLbusMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_LBUS_MODE_GENERATE                   = 302
Global Const HPE1432_LBUS_MODE_PIPE                       = 303
Global Const HPE1432_LBUS_MODE_INSERT                     = 304
Global Const HPE1432_LBUS_MODE_APPEND                     = 305
Global Const HPE1432_LBUS_MODE_CONSUME                    = 306

' Used by Function hpe1432_setMaxOrder
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_MAX_ORDER_MAX                        = 500
Global Const HPE1432_MAX_ORDER_MIN                        = 1

' Used by Function hpe1432_setMeasTimeLength
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_MEAS_TIME_LENGTH_MAX                 = 2000000000.0
Global Const HPE1432_MEAS_TIME_LENGTH_MIN                 = 0.0

' Used by Function hpe1432_setMmfDelay
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_MMF_DELAY_MAX                        = 2147483647
Global Const HPE1432_MMF_DELAY_MIN                        = 0

' Used by Function hpe1432_setMultiSync
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_MULTI_SYNC_ON                        = 220
Global Const HPE1432_MULTI_SYNC_OFF                       = 221
Global Const HPE1432_MULTI_SYNC_VXD                       = 222
Global Const HPE1432_MULTI_SYNC_VXD_MIN                   = 223

' Used by Function hpe1432_setOctaveAvgMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_OCTAVE_AVG_MODE_EXP                  = 760
Global Const HPE1432_OCTAVE_AVG_MODE_LIN                  = 761

' Used by Function hpe1432_setOctaveHoldMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_OCTAVE_HOLD_MODE_OFF                 = 765
Global Const HPE1432_OCTAVE_HOLD_MODE_MAX                 = 766
Global Const HPE1432_OCTAVE_HOLD_MODE_MIN                 = 767

' Used by Function hpe1432_setOctaveIntTime
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_OCTAVE_INT_TIME_MAX                  = 10000.0
Global Const HPE1432_OCTAVE_INT_TIME_MIN                  = 0.001953125

' Used by Function hpe1432_setOctaveMeas
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_OCTAVE_MEAS_ON                       = 386
Global Const HPE1432_OCTAVE_MEAS_OFF                      = 389

' Used by Function hpe1432_setOctaveMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_OCTAVE_MODE_FULL                     = 751
Global Const HPE1432_OCTAVE_MODE_THIRD                    = 752

' Used by Function hpe1432_setOctaveStartFreq
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_OCTAVE_START_FREQ_MAX                = 10000.0
Global Const HPE1432_OCTAVE_START_FREQ_MIN                = 3.15

' Used by Function hpe1432_setOctaveStopFreq
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_OCTAVE_STOP_FREQ_MAX                 = 20000.0
Global Const HPE1432_OCTAVE_STOP_FREQ_MIN                 = 3.15

' Used by Function hpe1432_setOctaveTimeConst
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_OCTAVE_TIME_CONST_MAX                = 16.0
Global Const HPE1432_OCTAVE_TIME_CONST_MIN                = 0.0078125

' Used by Function hpe1432_setOctaveTimeStep
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_OCTAVE_TIME_STEP_MAX                 = 10000.0
Global Const HPE1432_OCTAVE_TIME_STEP_MIN                 = 0.001953125

' Used by Function hpe1432_setOverlap
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_OVERLAP_MAX                          = 16777215
Global Const HPE1432_OVERLAP_MIN                          = -16777215

' Used by Function hpe1432_setPeakDecayTime
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_PEAK_DECAY_TIME_MAX                  = 40.0
Global Const HPE1432_PEAK_DECAY_TIME_MIN                  = 0.0

' Used by Function hpe1432_setPeakMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_PEAK_MODE_OFF                        = 580
Global Const HPE1432_PEAK_MODE_BLOCK                      = 581
Global Const HPE1432_PEAK_MODE_FILT                       = 582

' Used by Function hpe1432_setPreArmMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_MANUAL_ARM
'    HPE1432_AUTO_ARM
'    HPE1432_ARM_RPM_RUNUP
'    HPE1432_ARM_RPM_RUNDOWN
'    HPE1432_ARM_RPM_DELTA
Global Const HPE1432_ARM_EXTERNAL                         = 435

' Used by Function hpe1432_setPreArmRpm
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_PREARM_RPM_MAX                       = 300000.0
Global Const HPE1432_PREARM_RPM_MIN                       = 0.5

' Used by Function hpe1432_setRamp
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_RAMP_ON                              = 625
Global Const HPE1432_RAMP_OFF                             = 626

' Used by Function hpe1432_setRampRate
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_RAMP_RATE_MAX                        = 100
Global Const HPE1432_RAMP_RATE_MIN                        = 0

' Used by Function hpe1432_setRange
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_RANGE_MAX
'    HPE1432_RANGE_MIN

' Used by Function hpe1432_setRangeCharge
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_RANGE_MAX
'    HPE1432_RANGE_MIN

' Used by Function hpe1432_setRangeMike
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_RANGE_MAX
'    HPE1432_RANGE_MIN

' Used by Function hpe1432_setRmsAvgTime
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_RMS_AVG_TIME_MAX                     = 60.0
Global Const HPE1432_RMS_AVG_TIME_MIN                     = 0.0

' Used by Function hpe1432_setRmsDecayTime
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_RMS_DECAY_TIME_MAX                   = 60.0
Global Const HPE1432_RMS_DECAY_TIME_MIN                   = 0.0

' Used by Function hpe1432_setRmsMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_RMS_MODE_OFF                         = 590
Global Const HPE1432_RMS_MODE_BLOCK                       = 591
Global Const HPE1432_RMS_MODE_FILT                        = 592

' Used by Function hpe1432_setRpmHigh
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_RPM_HIGH_MAX                         = 300000.0
Global Const HPE1432_RPM_HIGH_MIN                         = 0.5

' Used by Function hpe1432_setRpmInterval
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_RPM_INTERVAL_MAX                     = 300000.0
Global Const HPE1432_RPM_INTERVAL_MIN                     = 0.1

' Used by Function hpe1432_setRpmLow
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_RPM_LOW_MAX                          = 300000.0
Global Const HPE1432_RPM_LOW_MIN                          = 0.01

' Used by Function hpe1432_setRpmSmoothing
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_RPM_SMOOTHING_MAX                    = 1.0
Global Const HPE1432_RPM_SMOOTHING_MIN                    = 0.0

' Used by Function hpe1432_setSampleMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_RESAMP_NORMAL                        = 720
Global Const HPE1432_RESAMP_AT_TACH                       = 721

' Used by Function hpe1432_setSineFreq
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SINE_FREQ_MAX                        = 25600
Global Const HPE1432_SINE_FREQ_MIN                        = 0

' Used by Function hpe1432_setSinePhase
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SINE_PHASE_MAX                       = 360.0
Global Const HPE1432_SINE_PHASE_MIN                       = -360.0

' Used by Function hpe1432_setSourceBlocksize
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SOURCE_BUFFER_SIZE_MAX               = 8388608
Global Const HPE1432_SOURCE_BUFFER_SIZE_MIN               = 1

' Used by Function hpe1432_setSourceCenterFreq
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SOURCE_CENTER_FREQ_MAX               = 12800
Global Const HPE1432_SOURCE_CENTER_FREQ_MIN               = 0

' Used by Function hpe1432_setSourceCola
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SOURCE_COLA_OFF                      = 180
Global Const HPE1432_SOURCE_COLA_ON                       = 181

' Used by Function hpe1432_setSourceMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SOURCE_MODE_SINE                     = 170
Global Const HPE1432_SOURCE_MODE_BSINE                    = 171
Global Const HPE1432_SOURCE_MODE_RAND                     = 172
Global Const HPE1432_SOURCE_MODE_BRAND                    = 173
Global Const HPE1432_SOURCE_MODE_RANDZ                    = 174
Global Const HPE1432_SOURCE_MODE_BRANDZ                   = 175
Global Const HPE1432_SOURCE_MODE_ARB                      = 176
Global Const HPE1432_SOURCE_MODE_BARB                     = 177

' Used by Function hpe1432_setSourceOutput
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SOURCE_OUTPUT_NORMAL                 = 700
Global Const HPE1432_SOURCE_OUTPUT_GROUNDED               = 701
Global Const HPE1432_SOURCE_OUTPUT_OPEN                   = 702
Global Const HPE1432_SOURCE_OUTPUT_CAL                    = 703
Global Const HPE1432_SOURCE_OUTPUT_MULTI                  = 704

' Used by Function hpe1432_setSourceSeed
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SOURCE_SEED_MAX                      = 255
Global Const HPE1432_SOURCE_SEED_MIN                      = 0

' Used by Function hpe1432_setSourceSpan
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SOURCE_SPAN_MAX                      = 25600
Global Const HPE1432_SOURCE_SPAN_MIN                      = 0

' Used by Function hpe1432_setSourceSum
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SOURCE_SUM_OFF                       = 190
Global Const HPE1432_SOURCE_SUM_ON                        = 191

' Used by Function hpe1432_setSpan
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SPAN_MAX                             = 78125.0
Global Const HPE1432_SPAN_MIN                             = 0.024

' Used by Function hpe1432_setSrcBufferInit
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SRC_BUFFER_INIT_EMPTY                = 1
Global Const HPE1432_SRC_BUFFER_INIT_RESET                = 2
Global Const HPE1432_SRC_BUFFER_INIT_XFER                 = 3

' Used by Function hpe1432_setSrcBufferMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SRC_BUFFER_CONTINUOUS                = 1
Global Const HPE1432_SRC_BUFFER_PERIODIC_AB               = 2
Global Const HPE1432_SRC_BUFFER_PERIODIC_A                = 4
Global Const HPE1432_SRC_BUFFER_SWITCHED_AUTO             = 8
Global Const HPE1432_SRC_BUFFER_SWITCHED_CMD              = 16
Global Const HPE1432_SRCBUFFER_ONESHOT                    = 32

' Used by Function hpe1432_setSrcBufferSize
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SRC_BUFFER_SIZE_MAX                  = 8388608
Global Const HPE1432_SRC_BUFFER_SIZE_MIN                  = 1

' Used by Function hpe1432_setSrcParmMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SRCPARM_MODE_IMMED                   = 0
Global Const HPE1432_SRCPARM_MODE_DEFR                    = 1

' Used by Function hpe1432_setSumbus
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SUMBUS_OFF                           = 520
Global Const HPE1432_SUMBUS_CALOUT                        = 521

' Used by Function hpe1432_setTachDecimate
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_TACH_DECIMATE_MAX                    = 65535
Global Const HPE1432_TACH_DECIMATE_MIN                    = 0

' Used by Function hpe1432_setTachHoldoff
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_TACH_HOLDOFF_MAX                     = 0.05
Global Const HPE1432_TACH_HOLDOFF_MIN                     = 0.0

' Used by Function hpe1432_setTachIrqNumber
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_TACH_IRQ_NUMBER_MAX                  = 4096
Global Const HPE1432_TACH_IRQ_NUMBER_MIN                  = 1

' Used by Function hpe1432_setTachMaxTime
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_MAX_TIME_MAX                         = 20000000000.0
Global Const HPE1432_MAX_TIME_MIN                         = 0.0

' Used by Function hpe1432_setTachPpr
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_TACH_PPR_MAX                         = 65536.0
Global Const HPE1432_TACH_PPR_MIN                         = 0.000001

' Used by Function hpe1432_setTraceLevel
Global Const HPE1432_TRACE_LEVEL_MAX                      = 999
Global Const HPE1432_TRACE_LEVEL_MIN                      = 0

' Used by Function hpe1432_setTrigger
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_CHANNEL_ON
'    HPE1432_CHANNEL_OFF
'    HPE1432_CHANNEL_MAYBE
Global Const HPE1432_TRIG_DELAY_MAX                       = 16777215
Global Const HPE1432_TRIG_DELAY_MIN                       = -16777215
Global Const HPE1432_TRIGGER_LEVEL_MAX                    = 125
Global Const HPE1432_TRIGGER_LEVEL_MIN                    = -125
'    HPE1432_TRIGGER_LEVEL_MAX
'    HPE1432_TRIGGER_LEVEL_MIN
Global Const HPE1432_TRIGGER_SLOPE_POS                    = 410
Global Const HPE1432_TRIGGER_SLOPE_NEG                    = 411
Global Const HPE1432_TRIGGER_MODE_LEVEL                   = 414
Global Const HPE1432_TRIGGER_MODE_BOUND                   = 415

' Used by Function hpe1432_setTriggerChannel
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_CHANNEL_ON
'    HPE1432_CHANNEL_OFF
'    HPE1432_CHANNEL_MAYBE
Global Const HPE1432_CHANNEL_PRE_ARM                      = 423

' Used by Function hpe1432_setTriggerDelay
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_TRIG_DELAY_MAX
'    HPE1432_TRIG_DELAY_MIN

' Used by Function hpe1432_setTriggerExt
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_TRIGGER_EXT_OFF                      = 470
Global Const HPE1432_TRIGGER_EXT_POS                      = 471
Global Const HPE1432_TRIGGER_EXT_NEG                      = 472
Global Const HPE1432_TRIGGER_EXT_PREARM_POS               = 473
Global Const HPE1432_TRIGGER_EXT_PREARM_NEG               = 474

' Used by Function hpe1432_setTriggerLevel
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_TRIGGER_LEVEL_LOWER
'    HPE1432_TRIGGER_LEVEL_UPPER
'    HPE1432_TRIGGER_LEVEL_MAX
'    HPE1432_TRIGGER_LEVEL_MIN

' Used by Function hpe1432_setTriggerMaster
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_TRIGGER_MASTER_OFF                   = 450
Global Const HPE1432_TRIGGER_SLAVE                        = 451
Global Const HPE1432_TRIGGER_MASTER_ON                    = 452

' Used by Function hpe1432_setTriggerMode
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_TRIGGER_MODE_LEVEL
'    HPE1432_TRIGGER_MODE_BOUND

' Used by Function hpe1432_setTriggerSlope
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_TRIGGER_SLOPE_POS
'    HPE1432_TRIGGER_SLOPE_NEG

' Used by Function hpe1432_setTriggersPerArm
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_TRIGGERS_PER_ARM_MAX                 = 2147483647
Global Const HPE1432_TRIGGERS_PER_ARM_MIN                 = 0

' Used by Function hpe1432_setTtltrgClock
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_TTLTRG_0                             = 261
Global Const HPE1432_TTLTRG_1                             = 262
Global Const HPE1432_TTLTRG_2                             = 263
Global Const HPE1432_TTLTRG_3                             = 264
Global Const HPE1432_TTLTRG_4                             = 265
Global Const HPE1432_TTLTRG_5                             = 266
Global Const HPE1432_TTLTRG_6                             = 267
Global Const HPE1432_TTLTRG_7                             = 268

' Used by Function hpe1432_setTtltrgGclock
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_TTLTRG_0
'    HPE1432_TTLTRG_1
'    HPE1432_TTLTRG_2
'    HPE1432_TTLTRG_3
'    HPE1432_TTLTRG_4
'    HPE1432_TTLTRG_5
'    HPE1432_TTLTRG_6
'    HPE1432_TTLTRG_7

' Used by Function hpe1432_setTtltrgLines
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_TTLTRG_0
'    HPE1432_TTLTRG_1
'    HPE1432_TTLTRG_2
'    HPE1432_TTLTRG_3
'    HPE1432_TTLTRG_4
'    HPE1432_TTLTRG_5
'    HPE1432_TTLTRG_6
'    HPE1432_TTLTRG_7

' Used by Function hpe1432_setTtltrgSatrg
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_TTLTRG_0
'    HPE1432_TTLTRG_1
'    HPE1432_TTLTRG_2
'    HPE1432_TTLTRG_3
'    HPE1432_TTLTRG_4
'    HPE1432_TTLTRG_5
'    HPE1432_TTLTRG_6
'    HPE1432_TTLTRG_7

' Used by Function hpe1432_setTtltrgTrigger
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_TTLTRG_0
'    HPE1432_TTLTRG_1
'    HPE1432_TTLTRG_2
'    HPE1432_TTLTRG_3
'    HPE1432_TTLTRG_4
'    HPE1432_TTLTRG_5
'    HPE1432_TTLTRG_6
'    HPE1432_TTLTRG_7

' Used by Function hpe1432_setUserData
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_UD_FRAME_MAX                         = 2147483647
Global Const HPE1432_UD_FRAME_MIN                         = 0
Global Const HPE1432_UD_WORD_MAX                          = 2147483647
Global Const HPE1432_UD_WORD_MIN                          = 0
Global Const HPE1432_UD_SUBLEN_MAX                        = 2147483647
Global Const HPE1432_UD_SUBLEN_MIN                        = 0
Global Const HPE1432_UD_SUBPOS_MAX                        = 2147483647
Global Const HPE1432_UD_SUBPOS_MIN                        = 0

' Used by Function hpe1432_setUserWindow
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_WINDOW_SCALE_MAX                     = 1000000.0
Global Const HPE1432_WINDOW_SCALE_MIN                     = 0.0

' Used by Function hpe1432_setWeighting
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_WEIGHTING_OFF                        = 105
Global Const HPE1432_WEIGHTING_A                          = 106
Global Const HPE1432_WEIGHTING_B                          = 107
Global Const HPE1432_WEIGHTING_C                          = 108

' Used by Function hpe1432_setWindow
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_WINDOW_UNIFORM                       = 710
Global Const HPE1432_WINDOW_HANNING                       = 711
Global Const HPE1432_WINDOW_FLATTOP                       = 712
Global Const HPE1432_WINDOW_USER                          = 713

' Used by Function hpe1432_setXferSize
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_XFER_SIZE_MAX                        = 16777215
Global Const HPE1432_XFER_SIZE_MIN                        = 0

' Used by Function hpe1432_setZoom
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_ZOOM_ON                              = 622
Global Const HPE1432_ZOOM_OFF                             = 623

' Used by Function hpe1432_srcGetFwrev
Global Const HPE1432_SRC_NUMWORDS_MAX                     = 33554432
Global Const HPE1432_SRC_NUMWORDS_MIN                     = 0

' Used by Function hpe1432_srcGetRev
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN

' Used by Function hpe1432_srcProgRomImage
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_SRC_NUMWORDS_MAX
'    HPE1432_SRC_NUMWORDS_MIN

' Used by Function hpe1432_srcRxfr
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_SRC_NUMWORDS_MAX
'    HPE1432_SRC_NUMWORDS_MIN
Global Const HPE1432_SRC_DATA_MODE_A                      = 1
Global Const HPE1432_SRC_DATA_MODE_B                      = 2
Global Const HPE1432_SRC_DATA_MODE_AB                     = 3
'    HPE1432_SRC_DATA_MODE_WAITA
'    HPE1432_SRC_DATA_MODE_WAITB
'    HPE1432_SRC_DATA_MODE_WAITAB
Global Const HPE1432_SRC_DATA_MODE_RESETA                 = 7
Global Const HPE1432_SRC_DATA_MODE_RESETB                 = 8

' Used by Function hpe1432_triggerMeasure
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_NO_WAIT_FLAG
'    HPE1432_WAIT_FLAG

' Used by Function hpe1432_updateSrcParm
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SRCPARM_UPDATE_IMMED                 = 0
Global Const HPE1432_SRCPARM_UPDATE_XING                  = 1
Global Const HPE1432_SRCPARM_UPDATE_TRGIN                 = 2
Global Const HPE1432_SRCPARM_UPDATE_IMMEDTRGOUT           = 3
Global Const HPE1432_SRCPARM_UPDATE_XINGTRGOUT            = 4
Global Const HPE1432_SRCPARM_UPDATE_TRGINTRGOUT           = 5

' Used by Function hpe1432_writeI2C
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
'    HPE1432_I2C_ADDRESS_MAX
'    HPE1432_I2C_ADDRESS_MIN
Global Const HPE1432_I2C_MAX                              = 255
Global Const HPE1432_I2C_MIN                              = 0

' Used by Function hpe1432_writeRegister16
'    HPE1432_CHANNEL_ID_MAX
'    HPE1432_CHANNEL_ID_MIN
'    HPE1432_REGISTER_MIN
'    HPE1432_REGISTER_MAX
Global Const HPE1432_MIN_16                               = -32768
Global Const HPE1432_MAX_16                               = 32767

' Used by Function hpe1432_writeRegister32
'    HPE1432_CHANNEL_ID_MAX
'    HPE1432_CHANNEL_ID_MIN
'    HPE1432_REGISTER_MIN
'    HPE1432_REGISTER_MAX
Global Const HPE1432_MAX_32                               = 2147483647
Global Const HPE1432_MIN_32                               = -2147483648

' Used by Function hpe1432_writeSrcBufferData
'    HPE1432_GROUP_ID_MAX
'    HPE1432_GROUP_ID_MIN
Global Const HPE1432_SRC_DATA_NUMWORDS_MAX                = 4096
Global Const HPE1432_SRC_DATA_NUMWORDS_MIN                = 1
'    HPE1432_SRC_DATA_MODE_A
'    HPE1432_SRC_DATA_MODE_B
'    HPE1432_SRC_DATA_MODE_AB
'    HPE1432_SRC_DATA_MODE_WAITA
'    HPE1432_SRC_DATA_MODE_WAITB
'    HPE1432_SRC_DATA_MODE_WAITAB
'    HPE1432_SRC_DATA_MODE_RESETA
'    HPE1432_SRC_DATA_MODE_RESETB


'------------------------------------------------------------------------------
' Function Declarations
'------------------------------------------------------------------------------

Declare Function hpe1432_armMeasure Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal wait As Long) As Long

Declare Function hpe1432_armMeasureMasterFinish Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal channel As Long) As Long

Declare Function hpe1432_armMeasureMasterSetup Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal channel As Long) As Long

Declare Function hpe1432_armMeasureSlaveFinish Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal channel As Long) As Long

Declare Function hpe1432_arrayControl Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal numChans As Long, darray As Double) As Long

Declare Function hpe1432_arrayNextChan Lib "hpe1432_32.dll" (ByVal vi As Long, chan As Long) As Long

Declare Function hpe1432_arrayReadChan Lib "hpe1432_32.dll" (ByVal vi As Long, chan As Long, data As Double) As Long

Declare Function hpe1432_autoRange Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal autoRangeTime As Double) As Long

Declare Function hpe1432_autoZero Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long) As Long

Declare Function hpe1432_blockAvailable Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, blockAvailable As Long) As Long

Declare Function hpe1432_cachedParmUpdate Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long) As Long


Declare Function hpe1432_channelGroupAdd Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal channel As Long) As Long

Declare Function hpe1432_channelGroupRemove Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal channel As Long) As Long

Declare Function hpe1432_checkOverloads Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, anyOver As Integer, common As Integer, diff As Integer, half As Integer) As Long

Declare Function hpe1432_checkSrcArbRdy Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal chan As Long, ByVal mode As Long, srcArbRdy As Long) As Long

Declare Function hpe1432_checkSrcOverload Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, srcOverload As Long) As Long

Declare Function hpe1432_checkSrcOverread Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, srcOverread As Long) As Long

Declare Function hpe1432_checkSrcShutdown Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, srcShutdown As Long) As Long

Declare Function hpe1432_checkSrcUnderrun Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, srcUnderrun As Long) As Long

Declare Function hpe1432_close Lib "hpe1432_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1432_createChannelGroup Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal num As Long, channels As Long, groupID As Long) As Long

Declare Function hpe1432_deleteAllChanGroups Lib "hpe1432_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1432_deleteChannelGroup Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long) As Long

Declare Function hpe1432_errorDetails Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal error As String, ByVal maxLen As Long) As Long

Declare Function hpe1432_errorDetails2 Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal error As String, ByVal maxLen As Long, actual As Long) As Long

Declare Function hpe1432_error_message Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal error As Long, ByVal message As String) As Long

Declare Function hpe1432_error_query Lib "hpe1432_32.dll" (ByVal vi As Long, error As Long, ByVal error_message As String) As Long

Declare Function hpe1432_find Lib "hpe1432_32.dll" (ByVal vi As Long, addList As Long, ByVal listSize As Long, numFound As Long, ByVal rsrc As String, ByVal rsrcLen As Long) As Long

Declare Function hpe1432_finishMeasure Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long) As Long

Declare Function hpe1432_getActive Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, active As Long) As Long

Declare Function hpe1432_getAmpScale Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ampScale As Double) As Long

Declare Function hpe1432_getAmpScaleLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getAntiAliasAnalog Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, antiAnalog As Long) As Long

Declare Function hpe1432_getAntiAliasDigital Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, antiDigital As Long) As Long

Declare Function hpe1432_getAppendStatus Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, status As Long) As Long

Declare Function hpe1432_getArmChannel Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, active As Long) As Long

Declare Function hpe1432_getArmMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, armMode As Long) As Long

Declare Function hpe1432_getArmTimeInterval Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, armTimeInt As Double) As Long

Declare Function hpe1432_getArmTimeIntervalLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getAutoGroupMeas Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, autoGroupMeas As Long) As Long

Declare Function hpe1432_getAutoRangeMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, arMode As Long) As Long

Declare Function hpe1432_getAutoTrigger Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, autoTrigger As Long) As Long

Declare Function hpe1432_getAvgMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, avgMode As Long) As Long

Declare Function hpe1432_getAvgNumber Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, avgNum As Long) As Long

Declare Function hpe1432_getAvgNumberLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getAvgUpdate Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, avgUp As Long) As Long

Declare Function hpe1432_getAvgUpdateLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getAvgWeight Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, avgWt As Double) As Long

Declare Function hpe1432_getAvgWeightLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getBlocksize Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, blocksize As Long) As Long

Declare Function hpe1432_getBlocksizeCurrentMax Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, blocksizeMax As Long) As Long

Declare Function hpe1432_getBlocksizeLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getCalDac Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, calDac As Long) As Long

Declare Function hpe1432_getCalDacLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getCalVoltage Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, calVolts As Double) As Long

Declare Function hpe1432_getCalVoltageLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getCalcData Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, calcData As Long) As Long

Declare Function hpe1432_getCalin Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, calInStatus As Long) As Long

Declare Function hpe1432_getCenterFreq Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, centerFreq As Double) As Long

Declare Function hpe1432_getCenterFreqLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getClockFreq Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, clockFreq As Double) As Long

Declare Function hpe1432_getClockFreqLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getClockMaster Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, clockMasterStatus As Long) As Long

Declare Function hpe1432_getClockSource Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, clockSource As Long) As Long

Declare Function hpe1432_getCoupling Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, coupling As Long) As Long

Declare Function hpe1432_getCouplingFreq Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, couplingFreq As Double) As Long

Declare Function hpe1432_getCouplingFreqLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getCurrentData Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal datatype As Long, ByVal datasize As Long, ByVal data As String, actualCnt As Long) As Long

Declare Function hpe1432_getCurrentRpm Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, currentRpm As Double) As Long

Declare Function hpe1432_getCurrentValue Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal channel As Long, ByVal valueType As Long, curVal As Double) As Long


Declare Function hpe1432_getDataMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, dataMode As Long) As Long

Declare Function hpe1432_getDataPort Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, dataPort As Long) As Long

Declare Function hpe1432_getDataRpm Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, currentRpm As Double) As Long

Declare Function hpe1432_getDataSize Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, dataSize As Long) As Long

Declare Function hpe1432_getDecimation Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, dec As Long) As Long

Declare Function hpe1432_getDecimationOutput Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, decOut As Long) As Long

Declare Function hpe1432_getDecimationOversample Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, decOversamp As Long) As Long

Declare Function hpe1432_getDecimationUndersamp Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, undersamp As Long) As Long

Declare Function hpe1432_getDecimationUndersampLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getDeltaOrder Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, delOrder As Double) As Long

Declare Function hpe1432_getDeltaOrderLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getDutyCycle Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, dutyCycle As Double) As Long

Declare Function hpe1432_getDutyCycleLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getEnable Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal dataType As Long, enable As Long) As Long

Declare Function hpe1432_getFifoSize Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, fifoSize As Long) As Long

Declare Function hpe1432_getFifoSizeCurrentMax Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, maxSize As Long) As Long

Declare Function hpe1432_getFifoSizeLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getFilterFreq Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, filterFreq As Double) As Long

Declare Function hpe1432_getFilterFreqLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getFilterSettlingTime Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, filtSetTime As Double) As Long

Declare Function hpe1432_getFilterSettlingTimeLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getFwrev Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal path As String, fwrev As Long) As Long

Declare Function hpe1432_getGroupInfo Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal item As Long, answer As Long, ByVal size As Long) As Long

Declare Function hpe1432_getHWConfig Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal modCount As Long, address As Long, configInfo As Long) As Long

Declare Function hpe1432_getInputHigh Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, inputHigh As Long) As Long

Declare Function hpe1432_getInputLow Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, inputLow As Long) As Long

Declare Function hpe1432_getInputMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, inputMode As Long) As Long

Declare Function hpe1432_getInputOffset Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, inputOffset As Double) As Long

Declare Function hpe1432_getInputOffsetLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getInterruptMask Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, intMask As Long) As Long

Declare Function hpe1432_getInterruptPriority Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, priority As Long) As Long

Declare Function hpe1432_getInterruptPriorityLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getInterruptReason Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal channel As Long, reason As Long) As Long

Declare Function hpe1432_getLbusMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, lbusMode As Long) As Long

Declare Function hpe1432_getLbusReset Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, lbusReset As Long) As Long

Declare Function hpe1432_getMaxOrder Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, maxOrder As Double) As Long

Declare Function hpe1432_getMaxOrderLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getMeasState Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, measState As Long) As Long

Declare Function hpe1432_getMeasTimeLength Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, measTime As Double) As Long

Declare Function hpe1432_getMeasTimeLengthLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getMeasWarning Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, warnings As Integer, ByVal bufferSize As Long, count As Long) As Long

Declare Function hpe1432_getMeasWarningString Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal warningString As String, ByVal bufferSize As Long, ByVal warning As Long) As Long

Declare Function hpe1432_getMmfDelay Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, mmfdelay As Long) As Long

Declare Function hpe1432_getMultiSync Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, multiSync As Long) As Long

Declare Function hpe1432_getNextArmRpm Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, nextArmRpm As Double) As Long

Declare Function hpe1432_getNumChans Lib "hpe1432_32.dll" (ByVal vi As Long, totalChans As Long, numInputs As Long, numSources As Long, numTachs As Long) As Long

Declare Function hpe1432_getOctaveAvgMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, octAvgMode As Long) As Long

Declare Function hpe1432_getOctaveBlocksize Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, octBlkSize As Long) As Long

Declare Function hpe1432_getOctaveHoldMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, octHoldMode As Long) As Long

Declare Function hpe1432_getOctaveIntTime Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, octIntTime As Double) As Long

Declare Function hpe1432_getOctaveIntTimeLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getOctaveMeas Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, octMeas As Long) As Long

Declare Function hpe1432_getOctaveMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, octaveMode As Long) As Long

Declare Function hpe1432_getOctaveStartFreq Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, octStartFreq As Double) As Long

Declare Function hpe1432_getOctaveStartFreqLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getOctaveStopFreq Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, octStopFreq As Double) As Long

Declare Function hpe1432_getOctaveStopFreqLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getOctaveTimeConst Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, octTimeConst As Double) As Long

Declare Function hpe1432_getOctaveTimeConstLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getOctaveTimeStep Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, octTimeStep As Double) As Long

Declare Function hpe1432_getOctaveTimeStepLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getOverlap Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, overlap As Long) As Long

Declare Function hpe1432_getOverlapLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getPeakDecayTime Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, peakDecayTime As Double) As Long

Declare Function hpe1432_getPeakDecayTimeLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getPeakMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, peakMode As Long) As Long

Declare Function hpe1432_getPreArmMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, preArmMode As Long) As Long

Declare Function hpe1432_getPreArmRpm Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, preArmRpm As Double) As Long

Declare Function hpe1432_getPreArmRpmLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getRamp Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ramp As Long) As Long

Declare Function hpe1432_getRampRate Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, rampRate As Double) As Long

Declare Function hpe1432_getRampRateLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getRange Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, range As Double) As Long

Declare Function hpe1432_getRangeCharge Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, range As Double) As Long

Declare Function hpe1432_getRangeChargeLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getRangeLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getRangeMike Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, range As Double) As Long

Declare Function hpe1432_getRangeMikeLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getRawTachs Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, buffer As Long, ByVal size As Long, actualCnt As Long) As Long

Declare Function hpe1432_getRmsAvgTime Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, rmsAvgTime As Double) As Long

Declare Function hpe1432_getRmsAvgTimeLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getRmsDecayTime Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, decayTime As Double) As Long

Declare Function hpe1432_getRmsDecayTimeLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getRmsMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, rmsMode As Long) As Long

Declare Function hpe1432_getRpmHigh Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, rpmHigh As Double) As Long

Declare Function hpe1432_getRpmHighLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getRpmInterval Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, rpmInt As Double) As Long

Declare Function hpe1432_getRpmIntervalLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getRpmLow Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, rpmLow As Double) As Long

Declare Function hpe1432_getRpmLowLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getRpmSmoothing Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, rpmSmooth As Double) As Long

Declare Function hpe1432_getRpmSmoothingLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getSampleMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, sampleMode As Long) As Long

Declare Function hpe1432_getSamplesToPreArm Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, samples As Long) As Long

Declare Function hpe1432_getScale Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, scaleFactor As Double) As Long

Declare Function hpe1432_getSerialNum Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal la As Long, ByVal serial As String) As Long

Declare Function hpe1432_getSineFreq Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, sineFreq As Double) As Long

Declare Function hpe1432_getSineFreqLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getSinePhase Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, sinePhase As Double) As Long

Declare Function hpe1432_getSinePhaseLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getSourceBlocksize Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, srcBlocksize As Long) As Long

Declare Function hpe1432_getSourceBlocksizeLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getSourceCenterFreq Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, srcCenterFreq As Double) As Long

Declare Function hpe1432_getSourceCenterFreqLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getSourceCola Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, srcCola As Long) As Long

Declare Function hpe1432_getSourceMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, srcMode As Long) As Long

Declare Function hpe1432_getSourceOutput Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, srcOutput As Long) As Long

Declare Function hpe1432_getSourceSeed Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, srcSeed As Long) As Long

Declare Function hpe1432_getSourceSeedLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getSourceSpan Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, srcSpan As Double) As Long

Declare Function hpe1432_getSourceSpanLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getSourceSum Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, srcSum As Long) As Long

Declare Function hpe1432_getSpan Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, span As Double) As Long

Declare Function hpe1432_getSpanLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getSrcArbStates Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal chan As Long, xfrBufWds As Long, srcBufStateAB As Long, srcBufStateA As Long, srcBufStateB As Long) As Long

Declare Function hpe1432_getSrcBufferInit Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, srcBufInit As Long) As Long

Declare Function hpe1432_getSrcBufferMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, srcBufMode As Long) As Long

Declare Function hpe1432_getSrcBufferSize Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, srcBufSize As Long) As Long

Declare Function hpe1432_getSrcBufferSizeLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getSrcParmMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, srcParmMode As Long) As Long

Declare Function hpe1432_getSumbus Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, sumbus As Long) As Long

Declare Function hpe1432_getTachClockFreq Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, tachClockFreq As Double) As Long

Declare Function hpe1432_getTachDecimate Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, tachDec As Long) As Long

Declare Function hpe1432_getTachDecimateLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getTachDelay Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, tachDelay As Double) As Long

Declare Function hpe1432_getTachHoldoff Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, tachHoldoff As Double) As Long

Declare Function hpe1432_getTachHoldoffLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getTachIrqNumber Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, irqNum As Long) As Long

Declare Function hpe1432_getTachIrqNumberLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getTachMaxTime Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, tachMaxTime As Double) As Long

Declare Function hpe1432_getTachMaxTimeLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getTachPpr Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, tachPpr As Double) As Long

Declare Function hpe1432_getTachPprLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getTrigCorr Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, trigcorr As Double) As Long

Declare Function hpe1432_getTriggerChannel Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, trigChan As Long) As Long

Declare Function hpe1432_getTriggerDelay Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, trigDelay As Long) As Long

Declare Function hpe1432_getTriggerDelayLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getTriggerExt Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, trigExt As Long) As Long

Declare Function hpe1432_getTriggerLevel Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal selectLevel As Long, trigLevel As Double) As Long

Declare Function hpe1432_getTriggerLevelLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal selectLevel As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getTriggerMaster Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, trigMaster As Long) As Long

Declare Function hpe1432_getTriggerMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, trigMode As Long) As Long

Declare Function hpe1432_getTriggerSlope Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, trigSlope As Long) As Long

Declare Function hpe1432_getTriggersPerArm Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, trigsPerArm As Long) As Long

Declare Function hpe1432_getTriggersPerArmLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getTtltrgClock Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ttlClock As Long) As Long

Declare Function hpe1432_getTtltrgGclock Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ttltrgGClock As Long) As Long

Declare Function hpe1432_getTtltrgLines Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ttltrgLines As Long) As Long

Declare Function hpe1432_getTtltrgSatrg Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ttltrgSatrg As Long) As Long

Declare Function hpe1432_getTtltrgTrigger Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ttltrgTrig As Long) As Long

Declare Function hpe1432_getWeighting Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, weight As Long) As Long

Declare Function hpe1432_getWindow Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, window As Long) As Long

Declare Function hpe1432_getXferSize Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, xferSize As Long) As Long

Declare Function hpe1432_getXferSizeLimits Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, min As Double, max As Double, def As Double, step As Double) As Long

Declare Function hpe1432_getZoom Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, zoom As Long) As Long

Declare Function hpe1432_init Lib "hpe1432_32.dll" (ByVal rsrcName As String, ByVal id_query As Integer, ByVal reset As Integer, vi As Long) As Long

Declare Function hpe1432_initMeasure Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal id As Long) As Long

Declare Function hpe1432_initMeasureFinish Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal wait As Long) As Long

Declare Function hpe1432_initMeasureToBooted Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal wait As Long) As Long

Declare Function hpe1432_install Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal numMods As Long, logAddrs As Long, ByVal file As String) As Long

Declare Function hpe1432_installFile Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal loc As String, ByVal fromMem As Long) As Long

Declare Function hpe1432_octaveCtl Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal octCtl As Long) As Long

Declare Function hpe1432_preArmMeasure Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal wait As Long) As Long

Declare Function hpe1432_preset Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long) As Long


Declare Function hpe1432_readFloat64Data Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal which As Long, data As Double, ByVal size As Long, actualCnt As Long, ByVal wait As Long) As Long

Declare Function hpe1432_readI2C Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal address As Long, i2cdata As Long) As Long

Declare Function hpe1432_readRawData Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal which As Long, ByVal data As String, ByVal size As Long, actualCnt As Long, ByVal wait As Long) As Long

Declare Function hpe1432_readRegister16 Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal channel As Long, ByVal reg As Long, data As Integer) As Long

Declare Function hpe1432_readRegister32 Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal channel As Long, ByVal reg As Long, data As Long) As Long

Declare Function hpe1432_readTrailerData Lib "hpe1432_32.dll" (ByVal vi As Long, trig As Double, zoom As Double, rpm1 As Double, rpm2 As Double, gap As Long, info As Long, peak As Double, rms As Double) As Long

Declare Function hpe1432_reenableInterrupt Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal channel As Long) As Long

Declare Function hpe1432_reset Lib "hpe1432_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1432_resetLbus Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal lbusReset As Long) As Long

Declare Function hpe1432_resetMeasure Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long) As Long

Declare Function hpe1432_revision_query Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal driver_rev As String, ByVal instr_rev As String) As Long

Declare Function hpe1432_scaDspDownload Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal length As Long, data As Long) As Long

Declare Function hpe1432_scaDspExecQuery Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal exec_cmd As Long, ByVal exec_data_size As Long, exec_data As Long, ByVal query_data_size As Long, query_data As Long) As Long

Declare Function hpe1432_selftest Lib "hpe1432_32.dll" (ByVal vi As Long, testResult As Integer, ByVal testMessage As String) As Long

Declare Function hpe1432_sendTachs Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal tach As Long, tachBuffer As Long, ByVal size As Long, count As Long) As Long

Declare Function hpe1432_sendTrigger Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long) As Long

Declare Function hpe1432_setActive Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal active As Long) As Long

Declare Function hpe1432_setAmpScale Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal ampScale As Double) As Long

Declare Function hpe1432_setAnalogInput Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal mode As Long, ByVal source As Long, ByVal state As Long, ByVal coupling As Long, ByVal range As Double) As Long

Declare Function hpe1432_setAntiAliasAnalog Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal antiAnalog As Long) As Long

Declare Function hpe1432_setAntiAliasDigital Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal antiDigital As Long) As Long

Declare Function hpe1432_setAppendStatus Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal appStatus As Long) As Long

Declare Function hpe1432_setArmChannel Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal armActive As Long) As Long

Declare Function hpe1432_setArmMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal armMode As Long) As Long

Declare Function hpe1432_setArmTimeInterval Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal armTimeInt As Double) As Long

Declare Function hpe1432_setAutoGroupMeas Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal autoGroupMeas As Long) As Long

Declare Function hpe1432_setAutoRangeMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal rangeMode As Long) As Long

Declare Function hpe1432_setAutoTrigger Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal autoTrigger As Long) As Long

Declare Function hpe1432_setAvgMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal avgMode As Long) As Long

Declare Function hpe1432_setAvgNumber Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal avgNum As Long) As Long

Declare Function hpe1432_setAvgUpdate Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal avgUp As Long) As Long

Declare Function hpe1432_setAvgWeight Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal avgWt As Double) As Long

Declare Function hpe1432_setBlocksize Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal blocksize As Long) As Long

Declare Function hpe1432_setCalDac Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal calDac As Long) As Long

Declare Function hpe1432_setCalVoltage Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal calVolts As Double) As Long

Declare Function hpe1432_setCalcData Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal calcData As Long) As Long

Declare Function hpe1432_setCalin Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal calInStatus As Long) As Long

Declare Function hpe1432_setCenterFreq Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal centerFreq As Double) As Long

Declare Function hpe1432_setClockFreq Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal clockFreq As Double) As Long

Declare Function hpe1432_setClockMaster Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal clockMasterStatus As Long) As Long

Declare Function hpe1432_setClockSource Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal clockSource As Long) As Long

Declare Function hpe1432_setCoupling Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal coupling As Long) As Long

Declare Function hpe1432_setCouplingFreq Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal couplingFreq As Double) As Long

Declare Function hpe1432_setDataFormat Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal blocksize As Long, ByVal dataSize As Long, ByVal mode As Long, ByVal append As Long) As Long

Declare Function hpe1432_setDataMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal dataMode As Long) As Long

Declare Function hpe1432_setDataPort Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal dataPort As Long) As Long

Declare Function hpe1432_setDataSize Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal dataSize As Long) As Long

Declare Function hpe1432_setDecimationOutput Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal decOut As Long) As Long

Declare Function hpe1432_setDecimationOversample Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal decOversamp As Long) As Long

Declare Function hpe1432_setDecimationUndersamp Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal undersamp As Long) As Long

Declare Function hpe1432_setDeltaOrder Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal delOrder As Double) As Long

Declare Function hpe1432_setDutyCycle Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal dutyCycle As Double) As Long

Declare Function hpe1432_setEnable Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal dataType As Long, ByVal enable As Long) As Long

Declare Function hpe1432_setFifoSize Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal fifoSize As Long) As Long

Declare Function hpe1432_setFilterFreq Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal filterFreq As Double) As Long

Declare Function hpe1432_setFilterSettlingTime Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal filtSetTime As Double) As Long

Declare Function hpe1432_setInputHigh Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal inputHigh As Long) As Long

Declare Function hpe1432_setInputLow Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal inputLow As Long) As Long

Declare Function hpe1432_setInputMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal inputMode As Long) As Long

Declare Function hpe1432_setInputOffset Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal inputOffset As Double) As Long

Declare Function hpe1432_setInterrupt Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal priority As Long, ByVal mask As Long) As Long

Declare Function hpe1432_setInterruptMask Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal intMask As Long) As Long

Declare Function hpe1432_setInterruptPriority Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal priority As Long) As Long

Declare Function hpe1432_setLbusMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal lbusMode As Long) As Long

Declare Function hpe1432_setMaxOrder Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal maxOrder As Double) As Long

Declare Function hpe1432_setMeasTimeLength Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal measTime As Double) As Long

Declare Function hpe1432_setMmfDelay Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal mmfdelay As Long) As Long

Declare Function hpe1432_setMultiSync Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal multiSync As Long) As Long

Declare Function hpe1432_setOctaveAvgMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal octAvgMode As Long) As Long

Declare Function hpe1432_setOctaveHoldMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal octHoldMode As Long) As Long

Declare Function hpe1432_setOctaveIntTime Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal octIntTime As Double) As Long

Declare Function hpe1432_setOctaveMeas Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal octAvgMode As Long) As Long

Declare Function hpe1432_setOctaveMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal OctaveMode As Long) As Long

Declare Function hpe1432_setOctaveStartFreq Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal octStartFreq As Double) As Long

Declare Function hpe1432_setOctaveStopFreq Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal octStopFreq As Double) As Long

Declare Function hpe1432_setOctaveTimeConst Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal octTimeConst As Double) As Long

Declare Function hpe1432_setOctaveTimeStep Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal octTimeStep As Double) As Long

Declare Function hpe1432_setOverlap Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal overlap As Long) As Long

Declare Function hpe1432_setPeakDecayTime Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal peakDecayTime As Double) As Long

Declare Function hpe1432_setPeakMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal peakMode As Long) As Long

Declare Function hpe1432_setPreArmMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal preArmMode As Long) As Long

Declare Function hpe1432_setPreArmRpm Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal preArmRpm As Double) As Long

Declare Function hpe1432_setRamp Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal ramp As Long) As Long

Declare Function hpe1432_setRampRate Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal rampRate As Double) As Long

Declare Function hpe1432_setRange Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal range As Double) As Long

Declare Function hpe1432_setRangeCharge Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal range As Double) As Long

Declare Function hpe1432_setRangeMike Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal range As Double) As Long

Declare Function hpe1432_setRmsAvgTime Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal rmsAvgTime As Double) As Long

Declare Function hpe1432_setRmsDecayTime Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal decayTime As Double) As Long

Declare Function hpe1432_setRmsMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal rmsMode As Long) As Long

Declare Function hpe1432_setRpmHigh Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal rpmHigh As Double) As Long

Declare Function hpe1432_setRpmInterval Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal rpmInt As Double) As Long

Declare Function hpe1432_setRpmLow Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal rpmLow As Double) As Long

Declare Function hpe1432_setRpmSmoothing Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal rpmSmooth As Double) As Long

Declare Function hpe1432_setSampleMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal sampleMode As Long) As Long

Declare Function hpe1432_setSineFreq Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal sineFreq As Double) As Long

Declare Function hpe1432_setSinePhase Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal sinePhase As Double) As Long

Declare Function hpe1432_setSourceBlocksize Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal srcBlocksize As Long) As Long

Declare Function hpe1432_setSourceCenterFreq Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal srcCenterFreq As Double) As Long

Declare Function hpe1432_setSourceCola Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal srcCola As Long) As Long

Declare Function hpe1432_setSourceMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal srcMode As Long) As Long

Declare Function hpe1432_setSourceOutput Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal srcOutput As Long) As Long

Declare Function hpe1432_setSourceSeed Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal srcSeed As Long) As Long

Declare Function hpe1432_setSourceSpan Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal srcSpan As Double) As Long

Declare Function hpe1432_setSourceSum Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal srcSum As Long) As Long

Declare Function hpe1432_setSpan Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal span As Double) As Long

Declare Function hpe1432_setSrcBufferInit Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal srcBufInit As Long) As Long

Declare Function hpe1432_setSrcBufferMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal srcBufMode As Long) As Long

Declare Function hpe1432_setSrcBufferSize Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal srcBufSize As Long) As Long

Declare Function hpe1432_setSrcParmMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal srcParmMode As Long) As Long

Declare Function hpe1432_setSumbus Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal sumbus As Long) As Long

Declare Function hpe1432_setTachDecimate Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal tachDec As Long) As Long

Declare Function hpe1432_setTachHoldoff Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal tachHoldoff As Double) As Long

Declare Function hpe1432_setTachIrqNumber Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal irqNum As Long) As Long

Declare Function hpe1432_setTachMaxTime Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal tachMaxTime As Double) As Long

Declare Function hpe1432_setTachPpr Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal tachPpr As Double) As Long

Declare Function hpe1432_setTraceLevel Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal tlevel As Long) As Long

Declare Function hpe1432_setTrigger Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal state As Long, ByVal delay As Long, ByVal level0 As Double, ByVal level1 As Double, ByVal slope As Long, ByVal mode As Long) As Long

Declare Function hpe1432_setTriggerChannel Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal trigChan As Long) As Long

Declare Function hpe1432_setTriggerDelay Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal trigDelay As Long) As Long

Declare Function hpe1432_setTriggerExt Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal trigExt As Long) As Long

Declare Function hpe1432_setTriggerLevel Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal selectLevel As Long, ByVal trigLevel As Double) As Long

Declare Function hpe1432_setTriggerMaster Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal trigMaster As Long) As Long

Declare Function hpe1432_setTriggerMode Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal trigMode As Long) As Long

Declare Function hpe1432_setTriggerSlope Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal trigSlope As Long) As Long

Declare Function hpe1432_setTriggersPerArm Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal trigsPerArm As Long) As Long

Declare Function hpe1432_setTtltrgClock Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal ttlClock As Long) As Long

Declare Function hpe1432_setTtltrgGclock Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal ttltrgGClock As Long) As Long

Declare Function hpe1432_setTtltrgLines Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal ttltrgLines As Long) As Long

Declare Function hpe1432_setTtltrgSatrg Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal ttltrgSatrg As Long) As Long

Declare Function hpe1432_setTtltrgTrigger Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal ttltrgTrig As Long) As Long

Declare Function hpe1432_setUserData Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal frameLen As Long, ByVal wordLen As Long, ByVal subLen As Long, ByVal subPos As Long) As Long

Declare Function hpe1432_setUserWindow Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, window As Double, ByVal wscale As Double) As Long

Declare Function hpe1432_setWeighting Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal weight As Long) As Long

Declare Function hpe1432_setWindow Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal window As Long) As Long

Declare Function hpe1432_setXferSize Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal xferSize As Long) As Long

Declare Function hpe1432_setZoom Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal zoom As Long) As Long

Declare Function hpe1432_srcGetFwrev Lib "hpe1432_32.dll" (ByVal vi As Long, dptr As Long, fwid As Long, fwdate As Long, ByVal numwords As Long) As Long

Declare Function hpe1432_srcGetRev Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal chan As Long, romid As Long, romdate As Long, bdid As Long, ByVal bddate As String) As Long

Declare Function hpe1432_srcProgRomImage Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal chan As Long, data As Long, ByVal numwords As Long) As Long

Declare Function hpe1432_srcRxfr Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal chan As Long, ByVal numwords As Long, data As Long, ByVal mode As Long) As Long

Declare Function hpe1432_triggerMeasure Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal wait As Long) As Long

Declare Function hpe1432_updateSrcParm Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal updateMode As Long) As Long

Declare Function hpe1432_writeI2C Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal group As Long, ByVal address As Long, ByVal i2cdata As Long) As Long

Declare Function hpe1432_writeRegister16 Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal channel As Long, ByVal reg As Long, ByVal data As Integer) As Long

Declare Function hpe1432_writeRegister32 Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal channel As Long, ByVal reg As Long, ByVal data As Long) As Long

Declare Function hpe1432_writeSrcBufferData Lib "hpe1432_32.dll" (ByVal vi As Long, ByVal chan As Long, dataPtr As Long, ByVal numWords As Long, ByVal mode As Long) As Long

